/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus.session;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZSessionPiece
implements AZMessage {
    private final DirectByteBuffer[] buffer = new DirectByteBuffer[2];
    private String description;
    private final int session_id;
    private final int piece_number;
    private final int piece_offset;
    private final int piece_length;

    public AZSessionPiece(int session_id, int piece_number, int piece_offset, DirectByteBuffer data) {
        this.session_id = session_id;
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.piece_length = data == null ? 0 : data.remaining((byte)6);
        this.buffer[1] = data;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public DirectByteBuffer getPieceData() {
        return this.buffer[1];
    }

    public String getID() {
        return "AZ_SESSION_PIECE";
    }

    public String getFeatureID() {
        throw new RuntimeException("not implemented");
    }

    public int getFeatureSubID() {
        throw new RuntimeException("not implemented");
    }

    public int getType() {
        return 1;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getID() + " session #" + this.session_id + " data for piece #" + this.piece_number + ":" + this.piece_offset + "->" + (this.piece_offset + this.piece_length - 1);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer[0] == null) {
            this.buffer[0] = DirectByteBufferPool.getBuffer((byte)12, 12);
            this.buffer[0].putInt((byte)11, this.session_id);
            this.buffer[0].putInt((byte)11, this.piece_number);
            this.buffer[0].putInt((byte)11, this.piece_offset);
            this.buffer[0].flip((byte)11);
        }
        return this.buffer;
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) < 12) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] < 12");
        }
        int id = data.getInt((byte)11);
        int number = data.getInt((byte)11);
        if (number < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: number < 0");
        }
        int offset = data.getInt((byte)11);
        if (offset < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: offset < 0");
        }
        return new AZSessionPiece(id, number, offset, data);
    }

    public void destroy() {
        if (this.buffer[0] != null) {
            this.buffer[0].returnToPool();
        }
        if (this.buffer[1] != null) {
            this.buffer[1].returnToPool();
        }
    }
}

