/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus.session;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZSessionRequest
implements AZMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int session_id;
    private final byte unchoke_id;
    private final int piece_number;
    private final int piece_offset;
    private final int length;
    private final int hashcode;

    public AZSessionRequest(int session_id, byte unchoke_id, int piece_number, int piece_offset, int length) {
        this.session_id = session_id;
        this.unchoke_id = unchoke_id;
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.length = length;
        this.hashcode = session_id + piece_number + piece_offset + length;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public byte getUnchokeID() {
        return this.unchoke_id;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getID() {
        return "AZ_SESSION_REQUEST";
    }

    public String getFeatureID() {
        throw new RuntimeException("not implemented");
    }

    public int getFeatureSubID() {
        throw new RuntimeException("not implemented");
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getID() + " session #" + this.session_id + " unchoke #" + this.unchoke_id + " piece #" + this.piece_number + ":" + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)12, 17);
            this.buffer.putInt((byte)11, this.session_id);
            this.buffer.put((byte)11, this.unchoke_id);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.putInt((byte)11, this.piece_offset);
            this.buffer.putInt((byte)11, this.length);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 17) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 17");
        }
        int sess = data.getInt((byte)11);
        byte unch = data.get((byte)11);
        int num = data.getInt((byte)11);
        if (num < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: num < 0");
        }
        int offset = data.getInt((byte)11);
        if (offset < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: offset < 0");
        }
        int lngth = data.getInt((byte)11);
        if (lngth < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: lngth < 0");
        }
        data.returnToPool();
        return new AZSessionRequest(sess, unch, num, offset, lngth);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof AZSessionRequest) {
            AZSessionRequest other = (AZSessionRequest)obj;
            if (other.session_id == this.session_id && other.piece_number == this.piece_number && other.piece_offset == this.piece_offset && other.length == this.length) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

