/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTRequest
implements BTMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int piece_number;
    private final int piece_offset;
    private final int length;
    private final int hashcode;

    public BTRequest(int piece_number, int piece_offset, int length) {
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.length = length;
        this.hashcode = piece_number + piece_offset + length;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getID() {
        return "BT_REQUEST";
    }

    public String getFeatureID() {
        return "BT1";
    }

    public int getFeatureSubID() {
        return 6;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_REQUEST piece #" + this.piece_number + ":" + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)19, 12);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.putInt((byte)11, this.piece_offset);
            this.buffer.putInt((byte)11, this.length);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 12) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 12");
        }
        int num = data.getInt((byte)11);
        if (num < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: num < 0");
        }
        int offset = data.getInt((byte)11);
        if (offset < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: offset < 0");
        }
        int lngth = data.getInt((byte)11);
        if (lngth < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: lngth < 0");
        }
        data.returnToPool();
        return new BTRequest(num, offset, lngth);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof BTRequest) {
            BTRequest other = (BTRequest)obj;
            if (other.piece_number == this.piece_number && other.piece_offset == this.piece_offset && other.length == this.length) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

