/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class PeerItem {
    private final byte[] address;
    private final int port;
    private final int source;
    private final int hashcode;
    private final int handshake;

    protected PeerItem(String _address, int port, int source, int handshake_type) {
        byte[] raw;
        try {
            InetAddress ip = InetAddress.getByName(_address);
            raw = ip.getAddress();
        }
        catch (UnknownHostException e) {
            raw = _address.getBytes();
        }
        this.address = raw;
        this.port = port;
        this.source = source;
        this.hashcode = new String(this.address).hashCode() + port;
        this.handshake = handshake_type;
        if (this.address.length != 4) {
            System.out.println("PeerItem OUT: address byte size=" + this.address.length);
        }
    }

    protected PeerItem(byte[] serialization, int source, int handshake_type) {
        this.address = new byte[serialization.length - 2];
        System.arraycopy(serialization, 0, this.address, 0, serialization.length - 2);
        byte p0 = serialization[serialization.length - 2];
        byte p1 = serialization[serialization.length - 1];
        this.port = (p1 & 0xFF) + ((p0 & 0xFF) << 8);
        this.source = source;
        this.hashcode = new String(this.address).hashCode() + this.port;
        this.handshake = handshake_type;
        if (this.address.length > 15) {
            System.out.println("PeerItem IN: address byte size=" + this.address.length);
        }
    }

    public byte[] getSerialization() {
        byte[] full_address = new byte[this.address.length + 2];
        System.arraycopy(this.address, 0, full_address, 0, this.address.length);
        full_address[this.address.length] = (byte)(this.port >> 8);
        full_address[this.address.length + 1] = (byte)(this.port & 0xFF);
        return full_address;
    }

    public String getAddressString() {
        try {
            return InetAddress.getByAddress(this.address).getHostAddress();
        }
        catch (UnknownHostException e) {
            return new String(this.address);
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getSource() {
        return this.source;
    }

    public int getHandshakeType() {
        return this.handshake;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PeerItem) {
            PeerItem other = (PeerItem)obj;
            if (this.port == other.port && Arrays.equals(this.address, other.address)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static String convertSourceString(int source_id) {
        switch (source_id) {
            case 0: {
                return "Tracker";
            }
            case 1: {
                return "DHT";
            }
            case 2: {
                return "PeerExchange";
            }
            case 3: {
                return "Plugin";
            }
            case 4: {
                return "Incoming";
            }
        }
        return "<unknown>";
    }

    public static int convertSourceID(String source) {
        if (source.equals("Tracker")) {
            return 0;
        }
        if (source.equals("DHT")) {
            return 1;
        }
        if (source.equals("PeerExchange")) {
            return 2;
        }
        if (source.equals("Plugin")) {
            return 3;
        }
        if (source.equals("Incoming")) {
            return 4;
        }
        return -1;
    }
}

