/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImpl;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTPlugin
implements Plugin {
    public static final int STATUS_DISABLED = 1;
    public static final int STATUS_INITALISING = 2;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_FAILED = 4;
    public static final byte FLAG_SINGLE_VALUE = 0;
    public static final byte FLAG_DOWNLOADING = 1;
    public static final byte FLAG_SEEDING = 2;
    public static final byte FLAG_MULTI_VALUE = 4;
    public static final int MAX_VALUE_SIZE = 256;
    private static final String PLUGIN_VERSION = "1.0";
    private static final String PLUGIN_NAME = "Distributed DB";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dht";
    private static final boolean TRACE_NON_MAIN = false;
    private static final boolean MAIN_DHT_ENABLE = true;
    private static final boolean CVS_DHT_ENABLE = true;
    private PluginInterface plugin_interface;
    private int status = 2;
    private DHTPluginImpl[] dhts;
    private ActionParameter reseed;
    private boolean enabled;
    private int dht_data_port;
    private boolean got_extended_use;
    private boolean extended_use;
    private AESemaphore init_sem = new AESemaphore("DHTPlugin:init");
    private AEMonitor port_change_mon = new AEMonitor("DHTPlugin:portChanger");
    private boolean port_changing;
    private int port_change_outstanding;
    private BooleanParameter ipfilter_logging;
    private UPnPMapping upnp_mapping;
    private LoggerChannel log;
    private DHTLogger dht_log;
    private List listeners = new ArrayList();

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", PLUGIN_VERSION);
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        this.dht_data_port = this.plugin_interface.getPluginconfig().getIntParameter("TCP.Listen.Port");
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_NAME);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("dht.info");
        BooleanParameter enabled_param = config.addBooleanParameter2("dht.enabled", "dht.enabled", true);
        final BooleanParameter use_default_port = config.addBooleanParameter2("dht.portdefault", "dht.portdefault", true);
        final IntParameter dht_port_param = config.addIntParameter2("dht.port", "dht.port", this.dht_data_port);
        use_default_port.addDisabledOnSelection(dht_port_param);
        dht_port_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter p) {
                int val = dht_port_param.getValue();
                if (val == 6880 || val == 6881) {
                    dht_port_param.setValue(6881);
                }
                if (val > 65535) {
                    dht_port_param.setValue(65535);
                }
                if (val < 1) {
                    dht_port_param.setValue(1);
                }
            }
        });
        if (!use_default_port.getValue()) {
            this.dht_data_port = dht_port_param.getValue();
        }
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            public void configSaved() {
                int new_dht_data_port_default = DHTPlugin.this.plugin_interface.getPluginconfig().getIntParameter("TCP.Listen.Port");
                int new_dht_data_port = dht_port_param.getValue();
                if (use_default_port.getValue()) {
                    if (new_dht_data_port != new_dht_data_port_default) {
                        dht_port_param.setValue(new_dht_data_port_default);
                        DHTPlugin.this.changePort(new_dht_data_port_default);
                    }
                } else if (new_dht_data_port != DHTPlugin.this.dht_data_port) {
                    DHTPlugin.this.changePort(new_dht_data_port);
                }
            }
        });
        LabelParameter reseed_label = config.addLabelParameter2("dht.reseed.label");
        final StringParameter reseed_ip = config.addStringParameter2("dht.reseed.ip", "dht.reseed.ip", "");
        final IntParameter reseed_port = config.addIntParameter2("dht.reseed.port", "dht.reseed.port", 0);
        this.reseed = config.addActionParameter2("dht.reseed.info", "dht.reseed");
        this.reseed.setEnabled(false);
        config.createGroup("dht.reseed.group", new Parameter[]{reseed_label, reseed_ip, reseed_port, this.reseed});
        this.ipfilter_logging = config.addBooleanParameter2("dht.ipfilter.log", "dht.ipfilter.log", true);
        final BooleanParameter advanced = config.addBooleanParameter2("dht.advanced", "dht.advanced", false);
        LabelParameter advanced_label = config.addLabelParameter2("dht.advanced.label");
        final StringParameter override_ip = config.addStringParameter2("dht.override.ip", "dht.override.ip", "");
        config.createGroup("dht.advanced.group", new Parameter[]{advanced_label, override_ip});
        advanced.addEnabledOnSelection(advanced_label);
        advanced.addEnabledOnSelection(override_ip);
        final StringParameter command = config.addStringParameter2("dht.execute.command", "dht.execute.command", "print");
        ActionParameter execute = config.addActionParameter2("dht.execute.info", "dht.execute");
        final BooleanParameter logging = config.addBooleanParameter2("dht.logging", "dht.logging", false);
        config.createGroup("dht.diagnostics.group", new Parameter[]{command, execute, logging});
        logging.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].setLogging(logging.getValue());
                    }
                }
            }
        });
        final DHTPluginOperationListener log_polistener = new DHTPluginOperationListener(){

            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                DHTPlugin.this.log.log("valueRead: " + new String(value.getValue()) + " from " + originator.getName());
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                DHTPlugin.this.log.log("valueWritten:" + new String(value.getValue()) + " to " + target.getName());
            }

            public void complete(boolean timeout_occurred) {
                DHTPlugin.this.log.log("complete: timeout = " + timeout_occurred);
            }
        };
        execute.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                AEThread t = new AEThread(this, "DHT:commandrunner"){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public void runSupport() {
                        if (DHTPlugin.access$200(5.access$400(this.this$1)) == null) {
                            return;
                        }
                        for (int i = 0; i < DHTPlugin.access$200(5.access$400(this.this$1)).length; ++i) {
                            DHT dht = DHTPlugin.access$200(5.access$400(this.this$1))[i].getDHT();
                            DHTTransportUDP transport = (DHTTransportUDP)dht.getTransport();
                            String c = 5.access$500(this.this$1).getValue().trim();
                            String lc = c.toLowerCase();
                            if (lc.equals("print")) {
                                dht.print();
                                DHTPlugin.access$200(5.access$400(this.this$1))[i].logStats();
                                continue;
                            }
                            if (lc.equals("testca")) {
                                ((DHTTransportUDPImpl)transport).testExternalAddressChange();
                                continue;
                            }
                            if (lc.equals("testnd")) {
                                ((DHTTransportUDPImpl)transport).testNetworkAlive(false);
                                continue;
                            }
                            if (lc.equals("testna")) {
                                ((DHTTransportUDPImpl)transport).testNetworkAlive(true);
                                continue;
                            }
                            int pos = c.indexOf(32);
                            if (pos == -1) continue;
                            String lhs = lc.substring(0, pos);
                            String rhs = c.substring(pos + 1);
                            if (lhs.equals("set")) {
                                pos = rhs.indexOf(61);
                                if (pos == -1) continue;
                                5.access$400(this.this$1).put(rhs.substring(0, pos).getBytes(), "DHT Plugin: set", rhs.substring(pos + 1).getBytes(), (byte)0, 5.access$600(this.this$1));
                                continue;
                            }
                            if (lhs.equals("get")) {
                                5.access$400(this.this$1).get(rhs.getBytes(), "DHT Plugin: get", (byte)0, 1, 10000L, true, 5.access$600(this.this$1));
                                continue;
                            }
                            if (lhs.equals("punch")) {
                                dht.getNATPuncher().punch(transport.getLocalContact());
                                continue;
                            }
                            if (!lhs.equals("stats")) continue;
                            try {
                                DHTTransportContact contact;
                                pos = rhs.indexOf(":");
                                if (pos == -1) {
                                    contact = transport.getLocalContact();
                                } else {
                                    String host = rhs.substring(0, pos);
                                    int port = Integer.parseInt(rhs.substring(pos + 1));
                                    contact = transport.importContact(new InetSocketAddress(host, port), transport.getProtocolVersion());
                                }
                                DHTTransportFullStats stats = contact.getStats();
                                DHTPlugin.access$300(5.access$400(this.this$1)).log("Stats:" + (stats == null ? "<null>" : stats.getString()));
                                DHTControlActivity[] activities = dht.getControl().getActivities();
                                for (int j = 0; j < activities.length; ++j) {
                                    DHTPlugin.access$300(5.access$400(this.this$1)).log("    act:" + activities[j].getString());
                                }
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            static /* synthetic */ DHTPlugin access$400(5 x0) {
                return x0.DHTPlugin.this;
            }

            static /* synthetic */ StringParameter access$500(5 x0) {
                return x0.command;
            }

            static /* synthetic */ DHTPluginOperationListener access$600(5 x0) {
                return x0.log_polistener;
            }
        });
        this.reseed.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DHTPlugin.this.reseed.setEnabled(false);
                AEThread t = new AEThread(this, "DHT:reseeder"){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        try {
                            String ip = 7.access$800(this.this$1).getValue().trim();
                            if (DHTPlugin.access$200(7.access$900(this.this$1)) == null) {
                                return;
                            }
                            int port = 7.access$1000(this.this$1).getValue();
                            for (int i = 0; i < DHTPlugin.access$200(7.access$900(this.this$1)).length; ++i) {
                                DHTPluginImpl dht = DHTPlugin.access$200(7.access$900(this.this$1))[i];
                                if (ip.length() == 0 || port == 0) {
                                    dht.checkForReSeed(true);
                                    continue;
                                }
                                if (dht.importSeed(ip, port) == null) continue;
                                dht.integrateDHT(false, null);
                            }
                        }
                        finally {
                            DHTPlugin.access$700(7.access$900(this.this$1)).setEnabled(true);
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            static /* synthetic */ StringParameter access$800(7 x0) {
                return x0.reseed_ip;
            }

            static /* synthetic */ DHTPlugin access$900(7 x0) {
                return x0.DHTPlugin.this;
            }

            static /* synthetic */ IntParameter access$1000(7 x0) {
                return x0.reseed_port;
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.dht_log = new DHTLogger(){

            public void log(String str) {
                DHTPlugin.this.log.log(str);
            }

            public void log(Throwable e) {
                DHTPlugin.this.log.log(e);
            }

            public void log(int log_type, String str) {
                if (this.isEnabled(log_type)) {
                    DHTPlugin.this.log.log(str);
                }
            }

            public boolean isEnabled(int log_type) {
                if (log_type == 2) {
                    return DHTPlugin.this.ipfilter_logging.getValue();
                }
                return true;
            }

            public PluginInterface getPluginInterface() {
                return DHTPlugin.this.log.getLogger().getPluginInterface();
            }
        };
        if (!enabled_param.getValue()) {
            model.getStatus().setText("Disabled");
            this.status = 1;
            this.init_sem.releaseForever();
            return;
        }
        PluginInterface pi_upnp = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (pi_upnp == null) {
            this.log.log("UPnP plugin not found, can't map port");
        } else {
            this.upnp_mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(this.plugin_interface.getPluginName(), false, this.dht_data_port, true);
        }
        this.setPluginInfo();
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                String ip = null;
                if (advanced.getValue() && (ip = override_ip.getValue().trim()).length() == 0) {
                    ip = null;
                }
                DHTPlugin.this.initComplete(model.getStatus(), logging.getValue(), ip);
            }

            public void closedownInitiated() {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].closedownInitiated();
                    }
                }
            }

            public void closedownComplete() {
            }
        });
        int sample_frequency = 60000;
        int sample_stats_ticks = 15;
        this.plugin_interface.getUtilities().createTimer("DHTStats").addPeriodicEvent(60000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event) {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].updateStats(15);
                    }
                }
                DHTPlugin.this.setPluginInfo();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changePort(int _new_port) {
        try {
            this.port_change_mon.enter();
            this.port_change_outstanding = _new_port;
            if (this.port_changing) {
                return;
            }
            this.port_changing = true;
        }
        finally {
            this.port_change_mon.exit();
        }
        new AEThread("DHTPlugin:portChanger", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void runSupport() {
                Object var4_4;
                int new_port;
                while (true) {
                    try {
                        DHTPlugin.this.port_change_mon.enter();
                        new_port = DHTPlugin.this.port_change_outstanding;
                    }
                    finally {
                        DHTPlugin.this.port_change_mon.exit();
                    }
                    DHTPlugin.this.dht_data_port = new_port;
                    if (DHTPlugin.this.upnp_mapping != null && DHTPlugin.this.upnp_mapping.getPort() != new_port) {
                        DHTPlugin.this.upnp_mapping.setPort(new_port);
                    }
                    if (DHTPlugin.this.status == 3 && DHTPlugin.this.dhts != null) {
                        for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                            if (DHTPlugin.this.dhts[i].getPort() == new_port) continue;
                            DHTPlugin.this.dhts[i].setPort(new_port);
                        }
                    }
                    var4_4 = null;
                    try {
                        DHTPlugin.this.port_change_mon.enter();
                        if (new_port != DHTPlugin.this.port_change_outstanding) continue;
                        DHTPlugin.this.port_changing = false;
                    }
                    finally {
                        DHTPlugin.this.port_change_mon.exit();
                        continue;
                    }
                    break;
                }
                return;
                catch (Throwable throwable) {
                    block15: {
                        var4_4 = null;
                        try {
                            DHTPlugin.this.port_change_mon.enter();
                            if (new_port != DHTPlugin.this.port_change_outstanding) break block15;
                            DHTPlugin.this.port_changing = false;
                        }
                        finally {
                            DHTPlugin.this.port_change_mon.exit();
                        }
                        return;
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    protected void initComplete(final UITextField status_area, final boolean logging, final String override_ip) {
        AEThread t = new AEThread("DHDPlugin.init"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    DHTPlugin.this.enabled = VersionCheckClient.getSingleton().DHTEnableAllowed();
                    if (DHTPlugin.this.enabled) {
                        status_area.setText("Initialising");
                        ArrayList<DHTPluginImpl> plugins = new ArrayList<DHTPluginImpl>();
                        DHTPluginImpl plug = new DHTPluginImpl(DHTPlugin.this.plugin_interface, 13, 0, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                        plugins.add(plug);
                        if (Constants.isCVSVersion()) {
                            plugins.add(new DHTPluginImpl(DHTPlugin.this.plugin_interface, 13, 1, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log));
                        }
                        DHTPluginImpl[] _dhts = new DHTPluginImpl[plugins.size()];
                        plugins.toArray(_dhts);
                        DHTPlugin.access$202(DHTPlugin.this, _dhts);
                        DHTPlugin.this.status = DHTPlugin.this.dhts[0].getStatus();
                        status_area.setText(DHTPlugin.this.dhts[0].getStatusText());
                        DHTPlugin.this.dhts[0].getDHT().getTransport().addListener(new DHTTransportListener(this){
                            private final /* synthetic */ 14 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void localContactChanged(DHTTransportContact local_contact) {
                                for (int i = 0; i < DHTPlugin.access$2000(14.access$1900(this.this$1)).size(); ++i) {
                                    ((DHTPluginListener)DHTPlugin.access$2000(14.access$1900(this.this$1)).get(i)).localAddressChanged(DHTPlugin.access$200(14.access$1900(this.this$1))[0].getLocalAddress());
                                }
                            }

                            public void currentAddress(String address) {
                            }

                            public void reachabilityChanged(boolean reacheable) {
                            }
                        });
                    } else {
                        DHTPlugin.this.status = 1;
                        status_area.setText("Disabled administratively due to network problems");
                    }
                }
                catch (Throwable e) {
                    DHTPlugin.this.enabled = false;
                    DHTPlugin.this.status = 1;
                    status_area.setText("Disabled due to error during initialisation");
                    DHTPlugin.this.log.log(e);
                    Debug.printStackTrace(e);
                }
                finally {
                    DHTPlugin.this.init_sem.releaseForever();
                }
                if (DHTPlugin.this.status == 3) {
                    DHTPlugin.this.changePort(DHTPlugin.this.dht_data_port);
                }
            }

            static /* synthetic */ DHTPlugin access$1900(14 x0) {
                return x0.DHTPlugin.this;
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void setPluginInfo() {
        boolean reachable = this.plugin_interface.getPluginconfig().getPluginBooleanParameter("dht.reachable.0", true);
        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", reachable ? "1" : "0");
    }

    public boolean isEnabled() {
        this.init_sem.reserve();
        return this.enabled;
    }

    public boolean peekEnabled() {
        if (this.init_sem.isReleasedForever()) {
            return this.enabled;
        }
        return true;
    }

    public boolean isExtendedUseAllowed() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.got_extended_use) {
            this.got_extended_use = true;
            this.extended_use = VersionCheckClient.getSingleton().DHTExtendedUseAllowed();
        }
        return this.extended_use;
    }

    public int getPort() {
        return this.dht_data_port;
    }

    public void put(final byte[] key, final String description, final byte[] value, final byte flags, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        this.dhts[0].put(key, description, value, flags, listener);
        int i = 1;
        while (i < this.dhts.length) {
            final int f_i = i++;
            new AEThread("mutli-dht: put", true){

                public void runSupport() {
                    DHTPlugin.this.dhts[f_i].put(key, description, value, flags, new DHTPluginOperationListener(this){
                        private final /* synthetic */ 16 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        public void complete(boolean timeout_occurred) {
                        }
                    });
                }
            }.start();
        }
    }

    public void get(final byte[] key, final String description, final byte flags, final int max_values, final long timeout, final boolean exhaustive, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        this.dhts[0].get(key, description, flags, max_values, timeout, exhaustive, listener);
        int i = 1;
        while (i < this.dhts.length) {
            final int f_i = i++;
            new AEThread("mutli-dht: get", true){

                public void runSupport() {
                    DHTPlugin.this.dhts[f_i].get(key, description, flags, max_values, timeout, exhaustive, new DHTPluginOperationListener(this){
                        private final /* synthetic */ 18 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        public void complete(boolean timeout_occurred) {
                        }
                    });
                }
            }.start();
        }
    }

    public void remove(final byte[] key, final String description, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        this.dhts[0].remove(key, description, listener);
        int i = 1;
        while (i < this.dhts.length) {
            final int f_i = i++;
            new AEThread("mutli-dht: remove", true){

                public void runSupport() {
                    DHTPlugin.this.dhts[f_i].remove(key, description, new DHTPluginOperationListener(this){
                        private final /* synthetic */ 20 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        public void complete(boolean timeout_occurred) {
                        }
                    });
                }
            }.start();
        }
    }

    public DHTPluginContact getLocalAddress() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalAddress();
    }

    public void registerHandler(byte[] handler_key, DHTPluginTransferHandler handler) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        for (int i = 0; i < this.dhts.length; ++i) {
            this.dhts[i].registerHandler(handler_key, handler);
        }
    }

    public byte[] read(DHTPluginProgressListener listener, final DHTPluginContact target, final byte[] handler_key, final byte[] key, final long timeout) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        int i = 1;
        while (i < this.dhts.length) {
            final int f_i = i++;
            new AEThread("mutli-dht: readXfer", true){

                public void runSupport() {
                    DHTPlugin.this.dhts[f_i].read(new DHTPluginProgressListener(this){
                        private final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void reportSize(long size) {
                        }

                        public void reportActivity(String str) {
                        }

                        public void reportCompleteness(int percent) {
                        }
                    }, target, handler_key, key, timeout);
                }
            }.start();
        }
        return this.dhts[0].read(listener, target, handler_key, key, timeout);
    }

    public int getStatus() {
        return this.status;
    }

    public DHT[] getDHTs() {
        if (this.dhts == null) {
            return new DHT[0];
        }
        DHT[] res = new DHT[this.dhts.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.dhts[i].getDHT();
        }
        return res;
    }

    public void addListener(DHTPluginListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DHTPluginListener l) {
        this.listeners.remove(l);
    }

    public void log(String str) {
        this.log.log(str);
    }

    static /* synthetic */ DHTPluginImpl[] access$202(DHTPlugin x0, DHTPluginImpl[] x1) {
        x0.dhts = x1;
        return x1;
    }

    static /* synthetic */ List access$2000(DHTPlugin x0) {
        return x0.listeners;
    }
}

