/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import java.net.URL;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderGetRight
extends ExternalSeedReaderImpl {
    private URL url;
    private String ip;
    private int port;
    private ExternalSeedHTTPDownloader http_downloader;

    protected ExternalSeedReaderGetRight(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url) {
        super(_plugin, _torrent);
        this.url = _url;
        this.ip = this.url.getHost();
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        this.http_downloader = new ExternalSeedHTTPDownloader(this.url, this.getUserAgent());
    }

    public String getName() {
        return "GR: " + this.url;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    protected boolean readyToActivate(PeerManager peer_manager) {
        int fail_count = this.getFailureCount();
        if (fail_count > 0) {
            int delay = 30000;
            for (int i = 1; i < fail_count && (delay += delay) <= 1800000; ++i) {
            }
            long now = this.getSystemTime();
            long last_fail = this.getLastFailTime();
            if (last_fail < now && now - last_fail < (long)delay) {
                return false;
            }
        }
        try {
            float availability = peer_manager.getDownload().getStats().getAvailability();
            if ((double)availability < 1.0) {
                this.log(this.getName() + ": activating as availability is poor");
                return true;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    protected boolean readyToDeactivate(PeerManager peer_manager) {
        try {
            float availability = peer_manager.getDownload().getStats().getAvailability();
            if ((double)availability >= 2.0) {
                this.log(this.getName() + ": deactivating as availability is good");
                return true;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    protected byte[] readData(PeerReadRequest request2) throws ExternalSeedException {
        return this.http_downloader.downloadRange((long)request2.getPieceNumber() * this.getTorrent().getPieceSize() + (long)request2.getOffset(), request2.getLength());
    }
}

