/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;

public class ExternalSeedHTTPDownloader {
    public static final String NL = "\r\n";
    private URL url;
    private String user_agent;
    private int last_response;

    public ExternalSeedHTTPDownloader(URL _url, String _user_agent) {
        this.url = _url;
        this.user_agent = _user_agent;
    }

    public byte[] download(int length) throws ExternalSeedException {
        return this.download(new String[0], new String[0], length);
    }

    public byte[] downloadRange(long offset, int length) throws ExternalSeedException {
        return this.download(new String[]{"Range"}, new String[]{"bytes=" + offset + "-" + (offset + (long)length - 1L)}, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(String[] prop_names, String[] prop_values, int length) throws ExternalSeedException {
        try {
            int response;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("User-Agent", this.user_agent);
            for (int i = 0; i < prop_names.length; ++i) {
                connection.setRequestProperty(prop_names[i], prop_values[i]);
            }
            this.last_response = response = connection.getResponseCode();
            if (response == 202 || response == 200 || response == 206) {
                byte[] data = new byte[length];
                InputStream is = connection.getInputStream();
                try {
                    int pos;
                    int len;
                    for (pos = 0; pos < length && (len = is.read(data, pos, length - pos)) >= 0; pos += len) {
                    }
                    if (pos != length) {
                        String data_str = new String(data, 0, length);
                        if (data_str.length() > 64) {
                            data_str = data_str.substring(0, 64);
                        }
                        throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [" + data_str + "]");
                    }
                }
                finally {
                    is.close();
                }
                return data;
            }
            ExternalSeedException error = new ExternalSeedException("Connection failed: " + connection.getResponseMessage());
            error.setPermanentFailure(true);
            throw error;
        }
        catch (Throwable e) {
            if (e instanceof ExternalSeedException) {
                throw (ExternalSeedException)e;
            }
            throw new ExternalSeedException("Connection failed", e);
        }
    }

    public byte[] downloadSocket(int length) throws ExternalSeedException {
        return this.downloadSocket(new String[0], new String[0], length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] downloadSocket(String[] prop_names, String[] prop_values, int length) throws ExternalSeedException {
        Socket socket = null;
        try {
            try {
                BufferedInputStream is;
                block23: {
                    int pos;
                    int len;
                    byte[] data;
                    block22: {
                        String response_str;
                        int response;
                        block21: {
                            byte[] buffer;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            PrintWriter pw = new PrintWriter(baos);
                            pw.print("GET " + this.url.getPath() + "?" + this.url.getQuery() + " HTTP/1.0" + NL);
                            pw.print("Host: " + this.url.getHost() + (this.url.getPort() == -1 ? "" : ":" + this.url.getPort()) + NL);
                            pw.print("Accept: */*\r\n");
                            pw.print("Connection: Keep-Alive\r\n");
                            pw.print("User-Agent: " + this.user_agent + NL);
                            for (int i = 0; i < prop_names.length; ++i) {
                                pw.print(prop_names[i] + ":" + prop_values[i] + NL);
                            }
                            pw.print(NL);
                            pw.flush();
                            socket = new Socket(this.url.getHost(), this.url.getPort() == -1 ? this.url.getDefaultPort() : this.url.getPort());
                            OutputStream os = socket.getOutputStream();
                            os.write(baos.toByteArray());
                            os.flush();
                            is = new BufferedInputStream(socket.getInputStream());
                            String header = "";
                            do {
                                int len2;
                                if ((len2 = ((InputStream)is).read(buffer = new byte[1])) >= 0) continue;
                                throw new IOException("input too short reading header");
                            } while (!(header = header + (char)buffer[0]).endsWith("\r\n\r\n"));
                            int line_end = header.indexOf(NL);
                            if (line_end == -1) {
                                throw new IOException("header too short");
                            }
                            String first_line = header.substring(0, line_end);
                            StringTokenizer tok = new StringTokenizer(first_line, " ");
                            tok.nextToken();
                            this.last_response = response = Integer.parseInt(tok.nextToken());
                            response_str = tok.nextToken();
                            if (response != 202 && response != 200 && response != 206) break block21;
                            data = new byte[length];
                            break block22;
                        }
                        if (response != 503) {
                            ExternalSeedException error = new ExternalSeedException("Connection failed: " + response_str);
                            error.setPermanentFailure(true);
                            throw error;
                        }
                        break block23;
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    for (pos = 0; pos < length && (len = ((InputStream)is).read(data, pos, length - pos)) >= 0; pos += len) {
                    }
                    if (pos != length) {
                        String data_str = new String(data, 0, length);
                        if (data_str.length() <= 64) throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [" + data_str + "]");
                        data_str = data_str.substring(0, 64);
                        throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [" + data_str + "]");
                    }
                    byte[] data_str = data;
                    return data_str;
                }
                String data_str = "";
                while (true) {
                    byte[] buffer;
                    int len;
                    if ((len = ((InputStream)is).read(buffer = new byte[1])) < 0) {
                        byte[] byArray = data_str.getBytes();
                        return byArray;
                    }
                    data_str = data_str + (char)buffer[0];
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ExternalSeedException)) throw new ExternalSeedException("Connection failed", e);
                throw (ExternalSeedException)e;
            }
        }
        catch (Throwable throwable) {
            Object var20_30 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw throwable;
            }
        }
    }

    public int getLastResponse() {
        return this.last_response;
    }
}

