/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.cache.JPCCache;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheUploader;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheUploaderAdapter;
import com.aelitis.azureus.plugins.jpc.cache.impl.JPCCacheManagerImpl;
import com.aelitis.azureus.plugins.jpc.cache.impl.JPCCacheMultiplexerHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimerTask;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.utils.Monitor;

public class JPCCacheMultiplexer {
    private final JPCPlugin jpc_plugin;
    private final JPCCacheManagerImpl manager;
    private final JPCCacheUploader cache;
    private final HashMap sessions = new HashMap();
    private final Monitor sessions_mon;
    private boolean is_established = false;
    private boolean is_establishing = false;
    private int uploader_id;
    private int session_idle_time;
    private int session_drop_time;
    private long last_message_transfered_time;
    private boolean is_authenticated = false;
    private boolean keep_alive_connect = false;
    private TimerTask idle_timer_task = new TimerTask(){

        public void run() {
            if (!JPCCacheMultiplexer.this.is_established) {
                return;
            }
            if (JPCCacheMultiplexer.this.session_idle_time < 1) {
                return;
            }
            if (System.currentTimeMillis() - JPCCacheMultiplexer.this.last_message_transfered_time > (long)(JPCCacheMultiplexer.this.session_idle_time * 1000)) {
                JPCCacheMultiplexer.this.jpc_plugin.log("Upload cache connection idle expired after [" + JPCCacheMultiplexer.this.session_idle_time + "sec], temporarily closing connection.  Keep-alive scheduled in [" + JPCCacheMultiplexer.this.session_drop_time + "sec]", 2);
                JPCCacheMultiplexer.this.closeCacheConnection();
            }
        }
    };
    private final JPCCacheMultiplexerHelper.Listener helper_listener = new JPCCacheMultiplexerHelper.Listener(){

        public void messageSent() {
            JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
        }

        public void establishmentNeeded() {
            JPCCacheMultiplexer.this.establishCacheConnection();
        }
    };
    private final JPCCacheUploaderAdapter upload_adapter = new JPCCacheUploaderAdapter(){

        public void connectSuccess(JPCCache up_cache, boolean is_new_discovery) {
            JPCCacheMultiplexer.this.is_established = true;
            JPCCacheMultiplexer.this.is_establishing = false;
            if (JPCCacheMultiplexer.this.is_authenticated) {
                JPCCacheMultiplexer.this.cache.sendActive();
                JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            } else {
                JPCCacheMultiplexer.this.cache.sendHello(JPCCacheMultiplexer.this.jpc_plugin.getPluginInterface().getAzureusName() + "/" + JPCCacheMultiplexer.this.jpc_plugin.getPluginInterface().getAzureusVersion());
                JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedReply(int peer_id, int idle_time, int drop_timeout) {
            JPCCacheMultiplexer.this.jpc_plugin.log("Upload cache connection succeeded, using cache.", 1);
            JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            try {
                JPCCacheMultiplexer.this.sessions_mon.enter();
                JPCCacheMultiplexer.this.is_authenticated = true;
                JPCCacheMultiplexer.this.uploader_id = peer_id;
                JPCCacheMultiplexer.this.session_idle_time = idle_time;
                JPCCacheMultiplexer.this.session_drop_time = drop_timeout;
                JPCCacheMultiplexer.this.jpc_plugin.getPluginTimer().schedule(JPCCacheMultiplexer.this.idle_timer_task, 10000L, 10000L);
                Iterator it = JPCCacheMultiplexer.this.sessions.values().iterator();
                while (it.hasNext()) {
                    JPCCacheMultiplexerHelper helper = (JPCCacheMultiplexerHelper)it.next();
                    helper.sessionEstablished(JPCCacheMultiplexer.this.cache, JPCCacheMultiplexer.this.uploader_id);
                }
            }
            finally {
                JPCCacheMultiplexer.this.sessions_mon.exit();
            }
        }

        public void receivedActiveAck(int idle_time, int drop_timeout) {
            JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            JPCCacheMultiplexer.this.session_idle_time = idle_time;
            JPCCacheMultiplexer.this.session_drop_time = drop_timeout;
            if (JPCCacheMultiplexer.this.keep_alive_connect) {
                JPCCacheMultiplexer.this.jpc_plugin.log("Was keep-alive connect, dropping connection again", 2);
                JPCCacheMultiplexer.this.last_message_transfered_time = 0L;
                JPCCacheMultiplexer.this.keep_alive_connect = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedRequest(int peer_id, byte[] hash, int piece_index, int start_offset, int length) {
            JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            try {
                JPCCacheMultiplexer.this.sessions_mon.enter();
                JPCCacheMultiplexerHelper helper = (JPCCacheMultiplexerHelper)JPCCacheMultiplexer.this.sessions.get(new Integer(peer_id));
                if (helper == null) {
                    JPCCacheMultiplexer.this.jpc_plugin.log("receivedRequest() helper == null: request received for unknown downloader id", 2);
                    return;
                }
                helper.receivedRequest(hash, piece_index, start_offset, length);
            }
            finally {
                JPCCacheMultiplexer.this.sessions_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedDownloaded(int peer_id, byte[] hash, int piece_index, int start_offset, int length) {
            JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            try {
                JPCCacheMultiplexer.this.sessions_mon.enter();
                JPCCacheMultiplexerHelper helper = (JPCCacheMultiplexerHelper)JPCCacheMultiplexer.this.sessions.get(new Integer(peer_id));
                if (helper == null) {
                    JPCCacheMultiplexer.this.jpc_plugin.log("receivedDownloaded() helper == null: downloaded received for unknown downloader id", 2);
                    return;
                }
                helper.receivedDownloaded(hash, piece_index, start_offset, length);
            }
            finally {
                JPCCacheMultiplexer.this.sessions_mon.exit();
            }
        }

        public void receivedError(int peer_id, String reason) {
            JPCCacheMultiplexer.this.last_message_transfered_time = System.currentTimeMillis();
            if (peer_id == JPCCacheMultiplexer.this.uploader_id) {
                JPCCacheMultiplexer.this.jpc_plugin.log("RECEIVED ERROR TYPE 2 ON ACTIVE MESSAGE REPLY, CACHE CONNECTION TIMED OUT", 1);
                JPCCacheMultiplexer.this.destroy();
            }
            JPCCacheMultiplexer.this.jpc_plugin.log("Upload cache server reported error on download side for [#" + peer_id + "]: " + reason, 2);
            JPCCacheMultiplexer.this.deregisterSession(peer_id);
        }

        public void receivedBye(String reason) {
            this.connectionError(new JPCException("upload cache server said goodbye: " + reason));
        }

        public void connectionError(JPCException error) {
            JPCCacheMultiplexer.this.jpc_plugin.log("Upload cache connection error: " + error.getMessage(), 2);
            JPCCacheMultiplexer.this.destroy();
        }
    };

    protected JPCCacheMultiplexer(JPCPlugin plugin, JPCCacheManagerImpl cache_manager, JPCCacheUploader up_cache) {
        this.jpc_plugin = plugin;
        this.manager = cache_manager;
        this.cache = up_cache;
        this.sessions_mon = this.jpc_plugin.getPluginInterface().getUtilities().getMonitor();
        this.establishCacheConnection();
    }

    private void establishCacheConnection() {
        if (this.is_established || this.is_establishing) {
            return;
        }
        this.is_establishing = true;
        this.jpc_plugin.getPluginInterface().getUtilities().createThread("JPCRemoteUploadCacheConnect:" + this.cache.getAddress(), new Runnable(){

            public void run() {
                JPCCacheMultiplexer.this.jpc_plugin.log("Remote upload cache server [" + JPCCacheMultiplexer.this.cache.getAddress() + "] connection attempt started.", 2);
                try {
                    JPCCacheMultiplexer.this.cache.connect(JPCCacheMultiplexer.this.upload_adapter);
                }
                catch (JPCException e) {
                    e.printStackTrace();
                    JPCCacheMultiplexer.this.upload_adapter.connectionError(e);
                }
            }
        });
    }

    private void closeCacheConnection() {
        this.is_established = false;
        this.is_establishing = false;
        this.cache.closeConnection();
        if (this.session_drop_time < 1) {
            return;
        }
        this.jpc_plugin.getPluginTimer().schedule(new TimerTask(){

            public void run() {
                if (!JPCCacheMultiplexer.this.is_authenticated) {
                    return;
                }
                JPCCacheMultiplexer.this.keep_alive_connect = true;
                JPCCacheMultiplexer.this.jpc_plugin.log("Session keep-alive started", 2);
                JPCCacheMultiplexer.this.establishCacheConnection();
            }
        }, this.session_drop_time * 900);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSession(Download download, Peer download_peer, int downloader_id) {
        try {
            this.sessions_mon.enter();
            JPCCacheMultiplexerHelper helper = new JPCCacheMultiplexerHelper(this.jpc_plugin, download, download_peer, downloader_id, this.helper_listener);
            Integer id = new Integer(downloader_id);
            if (this.sessions.containsKey(id)) {
                this.jpc_plugin.log("REGISTER ERROR: session already registered: " + downloader_id, 2);
                return;
            }
            this.sessions.put(id, helper);
            if (this.is_authenticated) {
                helper.sessionEstablished(this.cache, this.uploader_id);
            }
        }
        finally {
            this.sessions_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deregisterSession(int downloader_id) {
        try {
            this.sessions_mon.enter();
            JPCCacheMultiplexerHelper helper = (JPCCacheMultiplexerHelper)this.sessions.remove(new Integer(downloader_id));
            if (helper == null) {
                boolean bl = false;
                return bl;
            }
            helper.destroy();
            if (this.sessions.isEmpty()) {
                this.jpc_plugin.log("No more sessions running for upload cache server [" + this.cache.getAddress() + "], terminating upload cache session", 2);
                this.destroy();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sessions_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        this.is_authenticated = false;
        this.is_established = false;
        this.is_establishing = false;
        try {
            this.sessions_mon.enter();
            this.idle_timer_task.cancel();
            Iterator it = this.sessions.values().iterator();
            while (it.hasNext()) {
                JPCCacheMultiplexerHelper helper = (JPCCacheMultiplexerHelper)it.next();
                helper.destroy();
            }
            this.sessions.clear();
        }
        finally {
            this.sessions_mon.exit();
        }
        if (this.cache != null) {
            this.cache.closeConnection();
            this.manager.removeRemoteUploadCache(this.cache.getAddress());
        }
    }
}

