/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl;

import java.util.Arrays;

public class PieceRequest {
    private final byte[] hash;
    private final int piece;
    private final int offset;
    private final int length;
    private final int hashcode;

    public PieceRequest(byte[] infohash, int piece_number, int piece_offset, int length) {
        this.hash = infohash;
        this.piece = piece_number;
        this.offset = piece_offset;
        this.length = length;
        this.hashcode = (new String(infohash) + piece_number + piece_offset + length).hashCode();
    }

    public byte[] getHash() {
        return this.hash;
    }

    public int getPiece() {
        return this.piece;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PieceRequest)) {
            return false;
        }
        PieceRequest other = (PieceRequest)o;
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        if (this.piece != other.piece) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.length == other.length;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

