/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class JPCCancel
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer buffer;

    public JPCCancel(int session_id, byte[] infohash, int piece_number, int piece_offset, int length) {
        this.description = this.getID() + " session id# " + session_id + " infohash " + StaticUtilities.getFormatters().formatByteArray(infohash, true) + " piece #" + piece_number + ": " + piece_offset + "->" + (piece_offset + length - 1);
        this.buffer = ByteBuffer.allocate(36);
        this.buffer.putInt(session_id);
        this.buffer.put(infohash);
        this.buffer.putInt(piece_number);
        this.buffer.putInt(piece_offset);
        this.buffer.putInt(length);
        this.buffer.flip();
    }

    public String getID() {
        return "JPC_CANCEL";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() != 36) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] != 36");
        }
        int session_id = data.getInt();
        byte[] infohash = new byte[20];
        data.get(infohash);
        int piece_number = data.getInt();
        if (piece_number < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: piece_number < 0");
        }
        int piece_offset = data.getInt();
        if (piece_offset < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: piece_offset < 0");
        }
        int length = data.getInt();
        if (length < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: length < 0");
        }
        return new JPCCancel(session_id, infohash, piece_number, piece_offset, length);
    }
}

