/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.license.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.license.JPCLicense;
import com.aelitis.azureus.plugins.jpc.license.JPCLicenseEntry;
import com.aelitis.azureus.plugins.jpc.license.JPCLicenseVerifier;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;

public class JPCLicenseVerifierImpl
implements JPCLicenseVerifier {
    private static final byte[] raw_key = new byte[]{-11, 38, 94, 27, 31, -4, 99, 113, -117, -79, 100, 116, -88, 122, 36, -123, -10, 73, -16, -7, -75, -113, -123, -43, -55, 46, 15, 85, -101, -66, -41, 69, 119, -57, -63, -102, 88, -33, -109, 81, 33, -92, 111, 67, -40, 122, -84, -73, -8, 124, -35, 0, -49, 73, -36, 110, 89, 75, -64, -124, 72, 114, -40, -93, 77, 0, -69, 75, -43, 95, -126, 95, -88, -18, -55, -87, -115, 5, -91, -9, 87, -126, -45, 64, 123, 102, -45, -48, 95, 46, 54, 75, -59, -128, -4, -118, -127, 89, 43, 27, 4, 11, -84, -27, 62, -49, -77, 54, 116, 98, 97, 65, -14, -113, 68, 94, -125, -1, -37, 86, 57, -87, -14, 127, 75, 16, -79, -110, 53, -22, 3, -122, -85, 121, -82, -5, 116, 12, -111, -50, -62, 78, 86, 40, -40, 79, 75, 78, -4, 110, -73, -9, 22, 105, 48, 75, -103, 104, -65, 11, 84, 96, 101, 32, -114, -89, 85, 44, -74, -67, 69, -18, -55, 122, -74, -88, -52, 31, 116, 11, 67, 62, 54, -80, 76, 102, -50, 106, -67, -120, 48, 56, 19, -24, -38, 73, -49, 33, -100, 124, -127, 15, -122, -108, 56, 13, -120, 86, -83, -17, -29, 108, 29, 52, -125, -23, 26, -25, 120, 77, 83, -81, 57, 85, -60, 107, -108, 59, 63, -39, -79, 108, 54, -4, 8, 49, 74, -14, 106, -73, -73, -78, -7, -126, -57, 101, -3, -108, 21, 30, -25, 71, 8, -112, -102, -50};

    public JPCLicense verify(byte[] content) throws JPCException {
        int signature_length = 256;
        if (content.length < signature_length) {
            throw new JPCException("content is too short, must be at least 256 bytes");
        }
        int data_length = content.length - signature_length;
        try {
            byte[] signature = new byte[signature_length];
            System.arraycopy(content, content.length - signature_length, signature, 0, signature_length);
            BigInteger sig = this.decodeBigInteger(signature, true);
            BigInteger exponent = new BigInteger("3", 16);
            BigInteger modulus = this.decodeBigInteger(raw_key, true);
            BigInteger dec_sig = sig.modPow(exponent, modulus);
            byte[] dec_bytes = this.encodeBigInteger(dec_sig);
            MessageDigest d = MessageDigest.getInstance("MD5");
            d.update(content, 0, data_length);
            byte[] digest_bytes = d.digest();
            for (int i = 0; i < digest_bytes.length; ++i) {
                if (digest_bytes[i] == dec_bytes[dec_bytes.length - (i + 1)]) continue;
                throw new JPCException("Signature verification fails");
            }
            String content_str = new String(content, 0, content.length - 256);
            ArrayList<1> entries = new ArrayList<1>();
            int pos = 0;
            while (pos < content_str.length()) {
                int p1 = content_str.indexOf(10, pos);
                final String bit = p1 == -1 ? content_str.substring(pos).trim() : content_str.substring(pos, p1).trim();
                final int eq = bit.indexOf(61);
                if (eq == -1) {
                    throw new JPCException("Invalid license file - '=' missing at position " + pos);
                }
                entries.add(new JPCLicenseEntry(){

                    public String getName() {
                        return bit.substring(0, eq).trim();
                    }

                    public String getValue() {
                        return bit.substring(eq + 1).trim();
                    }
                });
                if (p1 == -1) break;
                pos = p1 + 1;
            }
            final JPCLicenseEntry[] entry_array = new JPCLicenseEntry[entries.size()];
            entries.toArray(entry_array);
            return new JPCLicense(){

                public JPCLicenseEntry[] getEntries() {
                    return entry_array;
                }
            };
        }
        catch (JPCException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JPCException("Signature verification fails", e);
        }
    }

    protected BigInteger decodeBigInteger(byte[] data, boolean reverse) {
        String str_key = "";
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i] & 0xFF);
            while (hex.length() < 2) {
                hex = "0" + hex;
            }
            str_key = reverse ? hex + str_key : str_key + hex;
        }
        BigInteger res = new BigInteger(str_key, 16);
        return res;
    }

    protected byte[] encodeBigInteger(BigInteger num) {
        String str = num.toString(16);
        if (str.length() % 2 == 1) {
            str = "0" + str;
        }
        byte[] res = new byte[str.length() / 2];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
        }
        return res;
    }

    public static void main(String[] args) {
        try {
            byte[] buffer;
            int len;
            InputStream is = JPCLicenseVerifierImpl.class.getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/jpc/license/impl/test_license.dat");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = is.read(buffer = new byte[65536])) > 0) {
                baos.write(buffer, 0, len);
            }
            JPCLicense license = new JPCLicenseVerifierImpl().verify(baos.toByteArray());
            JPCLicenseEntry[] entries = license.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                System.out.println("entry: " + entries[i].getName() + " -> " + entries[i].getValue());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

