/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;

public class DefaultRankCalculator
implements Comparable {
    public static final int FIRSTPRIORITY_ALL = 0;
    public static final int FIRSTPRIORITY_ANY = 1;
    private static final int FORCE_ACTIVE_FOR = 30000;
    private static final int ACTIVE_CHANGE_WAIT = 10000;
    private static int SPRATIO_BASE_LIMIT = 99999;
    private static int SEEDONLY_SHIFT = SPRATIO_BASE_LIMIT + 1;
    private static COConfigurationListener configListener = null;
    public static final int SR_COMPLETE_STARTS_AT = 1000000000;
    public static final int SR_TIMED_QUEUED_ENDS_AT = 999999;
    public static final int SR_IGNORED_LESS_THAN = -1;
    public static final int SR_NOTQUEUED = -2;
    public static final int SR_FP_SPRATIOMET = -3;
    public static final int SR_RATIOMET = -4;
    public static final int SR_NUMSEEDSMET = -5;
    public static final int SR_FP0PEERS = -6;
    public static final int SR_0PEERS = -7;
    public static final int SR_SHARERATIOMET = -8;
    protected static int iRankType = -1;
    private static int minPeersToBoostNoSeeds;
    private static int minSpeedForActiveDL;
    private static int minSpeedForActiveSeeding;
    private static int iIgnoreSeedCount;
    private static boolean bIgnore0Peers;
    private static int iIgnoreShareRatio;
    private static int iIgnoreShareRatio_SeedStart;
    private static int iIgnoreRatioPeers;
    private static int iIgnoreRatioPeers_SeedStart;
    private static int iRankTypeSeedFallback;
    private static boolean bPreferLargerSwarms;
    private static int minQueueingShareRatio;
    private static int iFirstPriorityIgnoreSPRatio;
    private static boolean bFirstPriorityIgnore0Peer;
    private static int iFirstPriorityType;
    private static int iFirstPrioritySeedingMinutes;
    private static int iFirstPriorityDLMinutes;
    private static long minTimeAlive;
    private static boolean bAutoStart0Peers;
    protected Download dl;
    private boolean bActivelyDownloading;
    private long lDLActivelyChangedOn;
    private boolean bActivelySeeding;
    private long lCDActivelyChangedOn;
    private boolean bIsFirstPriority;
    public String sExplainFP = "";
    public String sExplainSR = "";
    public String sTrace = "";
    private AEMonitor downloadData_this_mon = new AEMonitor("StartStopRules:downloadData");
    private final StartStopRulesDefaultPlugin rules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRankCalculator(StartStopRulesDefaultPlugin _rules, Download _dl) {
        this.rules = _rules;
        this.dl = _dl;
        try {
            this.downloadData_this_mon.enter();
            if (configListener == null) {
                configListener = new COConfigurationListener(){

                    public void configurationSaved() {
                        DefaultRankCalculator.reloadConfigParams(((DefaultRankCalculator)DefaultRankCalculator.this).rules.plugin_config);
                    }
                };
                COConfigurationManager.addListener(configListener);
                configListener.configurationSaved();
            }
        }
        finally {
            this.downloadData_this_mon.exit();
        }
    }

    public static void reloadConfigParams(PluginConfig cfg) {
        String PREFIX = "StartStopManager_";
        iRankType = cfg.getIntParameter("StartStopManager_iRankType");
        minPeersToBoostNoSeeds = cfg.getIntParameter("StartStopManager_iMinPeersToBoostNoSeeds");
        minSpeedForActiveDL = cfg.getIntParameter("StartStopManager_iMinSpeedForActiveDL");
        minSpeedForActiveSeeding = cfg.getIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
        iRankTypeSeedFallback = cfg.getIntParameter("StartStopManager_iRankTypeSeedFallback");
        bPreferLargerSwarms = cfg.getBooleanParameter("StartStopManager_bPreferLargerSwarms");
        minTimeAlive = cfg.getIntParameter("StartStopManager_iMinSeedingTime") * 1000;
        bAutoStart0Peers = cfg.getBooleanParameter("StartStopManager_bAutoStart0Peers");
        iIgnoreSeedCount = cfg.getIntParameter("StartStopManager_iIgnoreSeedCount");
        bIgnore0Peers = cfg.getBooleanParameter("StartStopManager_bIgnore0Peers");
        iIgnoreShareRatio = (int)(1000.0f * cfg.getFloatParameter("Stop Ratio"));
        iIgnoreShareRatio_SeedStart = cfg.getIntParameter("StartStopManager_iIgnoreShareRatioSeedStart");
        iIgnoreRatioPeers = cfg.getIntParameter("Stop Peers Ratio", 0);
        iIgnoreRatioPeers_SeedStart = cfg.getIntParameter("StartStopManager_iIgnoreRatioPeersSeedStart", 0);
        minQueueingShareRatio = cfg.getIntParameter("StartStopManager_iFirstPriority_ShareRatio");
        iFirstPriorityType = cfg.getIntParameter("StartStopManager_iFirstPriority_Type");
        iFirstPrioritySeedingMinutes = cfg.getIntParameter("StartStopManager_iFirstPriority_SeedingMinutes");
        iFirstPriorityDLMinutes = cfg.getIntParameter("StartStopManager_iFirstPriority_DLMinutes");
        iFirstPriorityIgnoreSPRatio = cfg.getIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio");
        bFirstPriorityIgnore0Peer = cfg.getBooleanParameter("StartStopManager_bFirstPriority_ignore0Peer");
    }

    public int compareTo(Object obj) {
        boolean bIsComplete;
        DefaultRankCalculator dlData = (DefaultRankCalculator)obj;
        boolean aIsComplete = dlData.dl.getStats().getDownloadCompleted(false) == 1000;
        boolean bl = bIsComplete = this.dl.getStats().getDownloadCompleted(false) == 1000;
        if (aIsComplete && !bIsComplete) {
            return 1;
        }
        if (!aIsComplete && bIsComplete) {
            return -1;
        }
        if (dlData.bIsFirstPriority && !this.bIsFirstPriority) {
            return 1;
        }
        if (!dlData.bIsFirstPriority && this.bIsFirstPriority) {
            return -1;
        }
        if (iRankType == 0) {
            return this.dl.getPosition() - dlData.dl.getPosition();
        }
        int value = dlData.dl.getSeedingRank() - this.dl.getSeedingRank();
        if (value != 0) {
            return value;
        }
        if (iRankType != 3) {
            int shareRatioThem;
            int numPeersThem = this.rules.calcPeersNoUs(dlData.dl);
            int numPeersUs = this.rules.calcPeersNoUs(this.dl);
            value = bPreferLargerSwarms ? numPeersThem - numPeersUs : numPeersUs - numPeersThem;
            if (value != 0) {
                return value;
            }
            int shareRatioUs = this.dl.getStats().getShareRatio();
            value = shareRatioUs - (shareRatioThem = dlData.dl.getStats().getShareRatio());
            if (value != 0) {
                return value;
            }
        }
        return this.dl.getPosition() - dlData.dl.getPosition();
    }

    public Download getDownloadObject() {
        return this.dl;
    }

    public boolean getActivelyDownloading() {
        boolean bIsActive = false;
        DownloadStats stats = this.dl.getStats();
        int state = this.dl.getState();
        if (state != 4) {
            bIsActive = false;
        } else if (System.currentTimeMillis() - stats.getTimeStarted() <= 30000L) {
            bIsActive = true;
        } else {
            boolean bl = bIsActive = stats.getDownloadAverage() >= (long)minSpeedForActiveDL;
            if (this.bActivelyDownloading != bIsActive) {
                long now = System.currentTimeMillis();
                if (this.lDLActivelyChangedOn == -1L) {
                    this.lDLActivelyChangedOn = now;
                    bIsActive = !bIsActive;
                } else if (now - this.lDLActivelyChangedOn < 10000L) {
                    bIsActive = !bIsActive;
                }
            } else {
                this.lDLActivelyChangedOn = -1L;
            }
        }
        if (this.bActivelyDownloading != bIsActive) {
            this.bActivelyDownloading = bIsActive;
            if (this.rules != null) {
                this.rules.requestProcessCycle();
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelyDownloading changed");
                }
            }
        }
        return this.bActivelyDownloading;
    }

    public boolean getActivelySeeding() {
        boolean bIsActive = false;
        DownloadStats stats = this.dl.getStats();
        int state = this.dl.getState();
        if (!(iRankType != 3 || this.isFirstPriority() || bAutoStart0Peers && this.rules.calcPeersNoUs(this.dl) == 0 && this.scrapeResultOk(this.dl))) {
            bIsActive = state == 5;
        } else if (state != 5 || bAutoStart0Peers && this.rules.calcPeersNoUs(this.dl) == 0) {
            bIsActive = false;
        } else if (System.currentTimeMillis() - stats.getTimeStarted() <= 30000L) {
            bIsActive = true;
        } else {
            boolean bl = bIsActive = stats.getUploadAverage() >= (long)minSpeedForActiveSeeding;
            if (this.bActivelySeeding != bIsActive) {
                long now = System.currentTimeMillis();
                if (this.lCDActivelyChangedOn == -1L) {
                    this.lCDActivelyChangedOn = now;
                    bIsActive = !bIsActive;
                } else if (now - this.lCDActivelyChangedOn < 10000L) {
                    bIsActive = !bIsActive;
                }
            } else {
                this.lCDActivelyChangedOn = -1L;
            }
        }
        if (this.bActivelySeeding != bIsActive) {
            this.bActivelySeeding = bIsActive;
            if (this.rules != null) {
                this.rules.requestProcessCycle();
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelySeeding changed");
                }
            }
        }
        return this.bActivelySeeding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recalcSeedingRank() {
        try {
            this.downloadData_this_mon.enter();
            if (this.rules.bDebugLog) {
                this.sExplainSR = "";
            }
            int oldSR = this.dl.getSeedingRank();
            DownloadStats stats = this.dl.getStats();
            int numCompleted = stats.getDownloadCompleted(false);
            if (numCompleted < 1000) {
                this.dl.setSeedingRank(1000000000 + (10000 - this.dl.getPosition()));
                int n = oldSR;
                return n;
            }
            int shareRatio = stats.getShareRatio();
            int numPeers = this.rules.calcPeersNoUs(this.dl);
            int numSeeds = this.rules.calcSeedsNoUs(this.dl);
            boolean bScrapeResultsOk = numPeers > 0 || numSeeds > 0 || this.scrapeResultOk(this.dl);
            int newSR = 0;
            if (!this.isFirstPriority()) {
                float ratio;
                if (!(iIgnoreShareRatio == 0 || shareRatio < iIgnoreShareRatio || numSeeds < iIgnoreShareRatio_SeedStart && this.scrapeResultOk(this.dl) || shareRatio == -1)) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  shareratio met: shareRatio(" + shareRatio + ") >= " + iIgnoreShareRatio + "\n";
                    }
                    this.dl.setSeedingRank(-8);
                    int n = -8;
                    return n;
                }
                if (this.rules.bDebugLog && iIgnoreShareRatio != 0 && shareRatio >= iIgnoreShareRatio) {
                    this.sExplainSR = this.sExplainSR + "  shareratio NOT met: ";
                    if (numSeeds >= iIgnoreShareRatio_SeedStart) {
                        this.sExplainSR = this.sExplainSR + numSeeds + " below seed threshold of " + iIgnoreShareRatio_SeedStart;
                    }
                    this.sExplainSR = this.sExplainSR + "\n";
                }
                if (numPeers == 0 && bScrapeResultsOk) {
                    if (bIgnore0Peers) {
                        if (this.rules.bDebugLog) {
                            this.sExplainSR = this.sExplainSR + "  Ignore 0 Peers criteria met\n";
                        }
                        this.dl.setSeedingRank(-7);
                        int n = -7;
                        return n;
                    }
                    if (bFirstPriorityIgnore0Peer) {
                        if (this.rules.bDebugLog) {
                            this.sExplainSR = this.sExplainSR + "  Ignore 0 Peers criteria for FP met\n";
                        }
                        this.dl.setSeedingRank(-6);
                        int n = -6;
                        return n;
                    }
                } else if (this.rules.bDebugLog && numPeers == 0) {
                    this.sExplainSR = this.sExplainSR + "  0 Peer Ignore rule NOT applied: Scrape invalid\n";
                }
                if (numPeers != 0 && iFirstPriorityIgnoreSPRatio != 0 && numSeeds / numPeers >= iFirstPriorityIgnoreSPRatio) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  Ignore rule for S:P Ratio for FP met.  Current: (" + numSeeds / numPeers + ") >= Threshold(" + iFirstPriorityIgnoreSPRatio + ")\n";
                    }
                    this.dl.setSeedingRank(-3);
                    int n = -3;
                    return n;
                }
                if (iIgnoreSeedCount != 0 && numSeeds >= iIgnoreSeedCount) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  SeedCount Ignore rule met.  numSeeds(" + numSeeds + " >= iIgnoreSeedCount(" + iIgnoreSeedCount + ")\n";
                    }
                    this.dl.setSeedingRank(-5);
                    int n = -5;
                    return n;
                }
                if (iIgnoreRatioPeers != 0 && numSeeds != 0 && (ratio = (float)numPeers / (float)numSeeds) <= (float)iIgnoreRatioPeers && numSeeds >= iIgnoreRatioPeers_SeedStart) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  P:S Ignore rule met.  ratio(" + ratio + " <= threshold(" + iIgnoreRatioPeers_SeedStart + ")\n";
                    }
                    this.dl.setSeedingRank(-4);
                    int n = -4;
                    return n;
                }
            }
            if (iRankType == 0) {
                if (this.rules.bDebugLog) {
                    this.sExplainSR = this.sExplainSR + "  Ranking Type set to none.. blanking seeding rank\n";
                }
                this.dl.setSeedingRank(newSR);
                int ratio = newSR;
                return ratio;
            }
            if (iRankType == 3) {
                if (this.bIsFirstPriority) {
                    this.dl.setSeedingRank(newSR + 999999 + 1);
                    int ratio = newSR;
                    return ratio;
                }
                int state = this.dl.getState();
                if (state == 6 || state == 7 || state == 8) {
                    this.dl.setSeedingRank(-2);
                    int n = -2;
                    return n;
                }
                if (state == 5 || state == 3 || state == 1 || state == 2) {
                    long lMsElapsed = 0L;
                    if (state == 5 && !this.dl.isForceStart()) {
                        lMsElapsed = SystemTime.getCurrentTime() - stats.getTimeStartedSeeding();
                    }
                    if (lMsElapsed >= minTimeAlive) {
                        this.dl.setSeedingRank(1);
                        if (oldSR > 999999) {
                            this.rules.requestProcessCycle();
                            if (this.rules.bDebugLog) {
                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: TimeUp");
                            }
                        }
                    } else {
                        newSR = 1000000 + (int)(lMsElapsed / 1000L);
                        this.dl.setSeedingRank(newSR);
                        if (oldSR <= 999999) {
                            this.rules.requestProcessCycle();
                            if (this.rules.bDebugLog) {
                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: strange timer change");
                            }
                        }
                    }
                    int n = newSR;
                    return n;
                }
                if (oldSR <= 0) {
                    newSR = 999999 - this.dl.getPosition();
                    this.dl.setSeedingRank(newSR);
                    this.rules.requestProcessCycle();
                    if (this.rules.bDebugLog) {
                        this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: NotIgnored");
                    }
                }
                int n = newSR;
                return n;
            }
            if (bScrapeResultsOk) {
                if (iRankType == 2 && (iRankTypeSeedFallback == 0 || iRankTypeSeedFallback > numSeeds)) {
                    newSR = numSeeds < 10000 ? 10000 - numSeeds : 1;
                    newSR *= SEEDONLY_SHIFT;
                } else if (numPeers != 0) {
                    if (numSeeds == 0) {
                        if (numPeers >= minPeersToBoostNoSeeds) {
                            newSR += SPRATIO_BASE_LIMIT;
                        }
                    } else {
                        float x = (float)numSeeds / (float)numPeers;
                        newSR = (int)((float)newSR + (float)SPRATIO_BASE_LIMIT / ((x + 1.0f) * (x + 1.0f)));
                    }
                }
            }
            if (newSR < 0) {
                newSR = 1;
            }
            if (newSR != oldSR) {
                this.dl.setSeedingRank(newSR);
            }
            int n = newSR;
            return n;
        }
        finally {
            this.downloadData_this_mon.exit();
        }
    }

    public boolean isFirstPriority() {
        boolean bFP = this.pisFirstPriority();
        if (this.bIsFirstPriority != bFP) {
            this.bIsFirstPriority = bFP;
            this.rules.requestProcessCycle();
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: FP changed");
            }
        }
        return this.bIsFirstPriority;
    }

    private boolean pisFirstPriority() {
        boolean bLastMatched;
        if (this.rules.bDebugLog) {
            this.sExplainFP = "FP if " + (iFirstPriorityType == 0 ? "all" : "any") + " criteria match:\n";
        }
        if (!this.dl.isPersistent()) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download not persistent\n";
            }
            return false;
        }
        if (this.dl.getStats().getDownloadCompleted(false) < 1000) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download not complete\n";
            }
            return false;
        }
        if (this.dl.getState() == 8 || this.dl.getState() == 7) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download is ERROR or STOPPED\n";
            }
            return false;
        }
        int numPeers = this.rules.calcPeersNoUs(this.dl);
        int numSeeds = this.rules.calcSeedsNoUs(this.dl);
        if (numPeers > 0 && numSeeds > 0 && numSeeds / numPeers >= iFirstPriorityIgnoreSPRatio && iFirstPriorityIgnoreSPRatio != 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: S:P >= " + iFirstPriorityIgnoreSPRatio + ":1\n";
            }
            return false;
        }
        if (numPeers == 0 && this.scrapeResultOk(this.dl) && bFirstPriorityIgnore0Peer) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: 0 peers\n";
            }
            return false;
        }
        int shareRatio = this.dl.getStats().getShareRatio();
        boolean bl = bLastMatched = shareRatio != -1 && shareRatio < minQueueingShareRatio;
        if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  shareRatio(" + shareRatio + ") < " + minQueueingShareRatio + "=" + bLastMatched + "\n";
        }
        if (!bLastMatched && iFirstPriorityType == 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
            }
            return false;
        }
        if (bLastMatched && iFirstPriorityType == 1) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
            }
            return true;
        }
        boolean bl2 = bLastMatched = iFirstPrioritySeedingMinutes == 0;
        if (!bLastMatched) {
            long timeSeeding = this.dl.getStats().getSecondsOnlySeeding();
            if (timeSeeding >= 0L) {
                boolean bl3 = bLastMatched = timeSeeding < (long)(iFirstPrioritySeedingMinutes * 60);
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "  SeedingTime(" + timeSeeding + ") < " + iFirstPrioritySeedingMinutes * 60 + "=" + bLastMatched + "\n";
                }
                if (!bLastMatched && iFirstPriorityType == 0) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
                    }
                    return false;
                }
                if (bLastMatched && iFirstPriorityType == 1) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
                    }
                    return true;
                }
            }
        } else if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  Skipping Seeding Time check (user disabled)\n";
        }
        boolean bl4 = bLastMatched = iFirstPriorityDLMinutes == 0;
        if (!bLastMatched) {
            long timeDLing = this.dl.getStats().getSecondsDownloading();
            if (timeDLing >= 0L) {
                boolean bl5 = bLastMatched = timeDLing < (long)(iFirstPriorityDLMinutes * 60);
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "  DLTime(" + timeDLing + ") < " + iFirstPriorityDLMinutes * 60 + "=" + bLastMatched + "\n";
                }
                if (!bLastMatched && iFirstPriorityType == 0) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
                    }
                    return false;
                }
                if (bLastMatched && iFirstPriorityType == 1) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
                    }
                    return true;
                }
            }
        } else if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  Skipping DL Time check (user disabled)\n";
        }
        if (iFirstPriorityType == 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Is FP\n";
            }
            return true;
        }
        if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "..Not FP\n";
        }
        return false;
    }

    public boolean getCachedIsFP() {
        return this.bIsFirstPriority;
    }

    public String toString() {
        return String.valueOf(this.dl.getSeedingRank());
    }

    public boolean changeChecker() {
        if (this.getActivelySeeding()) {
            int shareRatio = this.dl.getStats().getShareRatio();
            int numSeeds = this.rules.calcSeedsNoUs(this.dl);
            if (iIgnoreShareRatio != 0 && shareRatio > iIgnoreShareRatio && numSeeds >= iIgnoreShareRatio_SeedStart && shareRatio != -1) {
                return true;
            }
        }
        if (this.dl.getState() == 3) {
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: Download is ready");
            }
            return true;
        }
        return false;
    }

    private boolean scrapeResultOk(Download download) {
        DownloadScrapeResult sr = download.getLastScrapeResult();
        return sr.getResponseType() == 1;
    }
}

