/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;

public class UPnPMappingManager {
    protected static UPnPMappingManager singleton = new UPnPMappingManager();
    protected List mappings = new ArrayList();
    protected List listeners = new ArrayList();

    public static UPnPMappingManager getSingleton() {
        return singleton;
    }

    protected UPnPMappingManager() {
        this.addConfigPort("upnp.mapping.dataportudp", false, "Server Enable UDP", "TCP.Listen.Port");
        this.addConfigPort("upnp.mapping.dataport", true, "TCP.Listen.Port", true);
        this.addConfigPort("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port");
        this.addConfigPortX("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port Backups");
        this.addConfigPort("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL");
        this.addConfigPortX("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL Backups");
        this.addConfigPort("upnp.mapping.udptrackerport", false, "Tracker Port UDP Enable", "Tracker Port");
    }

    protected UPnPMapping addConfigPort(String name_resource, boolean tcp, final String int_param_name, boolean enabled) {
        int value = COConfigurationManager.getIntParameter(int_param_name);
        final UPnPMapping mapping = this.addMapping(name_resource, tcp, value, enabled);
        COConfigurationManager.addParameterListener(int_param_name, new ParameterListener(){

            public void parameterChanged(String name) {
                mapping.setPort(COConfigurationManager.getIntParameter(int_param_name));
            }
        });
        return mapping;
    }

    protected void addConfigPort(String name_resource, boolean tcp, final String enabler_param_name, String int_param_name) {
        boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
        final UPnPMapping mapping = this.addConfigPort(name_resource, tcp, int_param_name, enabled);
        COConfigurationManager.addParameterListener(enabler_param_name, new ParameterListener(){

            public void parameterChanged(String name) {
                mapping.setEnabled(COConfigurationManager.getBooleanParameter(enabler_param_name));
            }
        });
    }

    protected void addConfigPortX(final String name_resource, final boolean tcp, final String enabler_param_name, final String string_param_name) {
        final ArrayList config_mappings = new ArrayList();
        ParameterListener l1 = new ParameterListener(){

            public void parameterChanged(String name) {
                int i;
                boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                List ports = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string_param_name));
                for (i = 0; i < ports.size(); ++i) {
                    int port = (Integer)ports.get(i);
                    if (config_mappings.size() <= i) {
                        UPnPMapping mapping = UPnPMappingManager.this.addMapping(name_resource, tcp, port, enabled);
                        mapping.setEnabled(enabled);
                        config_mappings.add(mapping);
                        continue;
                    }
                    ((UPnPMapping)config_mappings.get(i)).setPort(port);
                }
                for (i = ports.size(); i < config_mappings.size(); ++i) {
                    ((UPnPMapping)config_mappings.get(i)).setEnabled(false);
                }
            }
        };
        COConfigurationManager.addParameterListener(string_param_name, l1);
        ParameterListener l2 = new ParameterListener(){

            public void parameterChanged(String name) {
                List ports = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string_param_name));
                boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                for (int i = 0; i < (enabled ? ports.size() : config_mappings.size()); ++i) {
                    ((UPnPMapping)config_mappings.get(i)).setEnabled(enabled);
                }
            }
        };
        COConfigurationManager.addParameterListener(enabler_param_name, l2);
        l1.parameterChanged(null);
        l2.parameterChanged(null);
    }

    protected List stringToPorts(String str) {
        str = str.replace(',', ';');
        StringTokenizer tok = new StringTokenizer(str, ";");
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (tok.hasMoreTokens()) {
            try {
                res.add(new Integer(tok.nextToken().trim()));
            }
            catch (Throwable e) {
                Debug.out("Invalid port entry in '" + str + "'", e);
            }
        }
        return res;
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        UPnPMapping mapping = new UPnPMapping(desc_resource, tcp, port, enabled);
        this.mappings.add(mapping);
        this.added(mapping);
        return mapping;
    }

    public UPnPMapping[] getMappings() {
        UPnPMapping[] res = new UPnPMapping[this.mappings.size()];
        this.mappings.toArray(res);
        return res;
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (mapping.isTCP() != tcp || mapping.getPort() != port) continue;
            return mapping;
        }
        return null;
    }

    protected void added(UPnPMapping mapping) {
        mapping.addListener(new UPnPMappingListener(){

            public void mappingChanged(UPnPMapping mapping) {
            }

            public void mappingDestroyed(UPnPMapping mapping) {
                UPnPMappingManager.this.mappings.remove(mapping);
            }
        });
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingManagerListener)this.listeners.get(i)).mappingAdded(mapping);
        }
    }

    public void addListener(UPnPMappingManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPMappingManagerListener l) {
        this.listeners.remove(l);
    }
}

