/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.SystemTime;

public class DownloadManagerStatsImpl
implements DownloadManagerStats {
    private DownloadManagerImpl download_manager;
    private int maxUploads = 4;
    private int completed;
    private int downloadCompleted;
    private long saved_data_bytes_downloaded;
    private long saved_protocol_bytes_downloaded;
    private long saved_data_bytes_uploaded;
    private long saved_protocol_bytes_uploaded;
    private long saved_discarded = 0L;
    private long saved_hashfails = 0L;
    private long saved_SecondsDownloading = 0L;
    private long saved_SecondsOnlySeeding = 0L;
    private int max_upload_rate_bps = 0;
    private int max_download_rate_bps = 0;

    protected DownloadManagerStatsImpl(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    public long getDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDataReceiveRate();
        }
        return 0L;
    }

    public long getProtocolReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getProtocolReceiveRate();
        }
        return 0L;
    }

    public long getDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDataSendRate();
        }
        return 0L;
    }

    public long getProtocolSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getProtocolSendRate();
        }
        return 0L;
    }

    public long getETA() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getETA();
        }
        return -1L;
    }

    public int getCompleted() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            int state = this.download_manager.getState();
            if (state == 20 || state == 30 || state == 5) {
                return this.completed;
            }
            return this.downloadCompleted;
        }
        if (dm.getState() == 2 || dm.getState() == 3 || dm.getState() == 1) {
            return dm.getPercentDone();
        }
        long total = dm.getTotalLength();
        return total == 0L ? 0 : (int)(1000L * (total - dm.getRemaining()) / total);
    }

    public void setCompleted(int _completed) {
        this.completed = _completed;
    }

    public int getDownloadCompleted(boolean bLive) {
        int computed_completion;
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            return this.downloadCompleted;
        }
        int state = dm.getState();
        boolean transient_state = state == 1 || state == 2 || state == 3;
        long total = dm.getTotalLength();
        int n = computed_completion = total == 0L ? 0 : (int)(1000L * (total - dm.getRemaining()) / total);
        if (!transient_state) {
            this.downloadCompleted = computed_completion;
        }
        if (bLive) {
            return computed_completion;
        }
        return this.downloadCompleted;
    }

    public void setDownloadCompleted(int _completed) {
        this.downloadCompleted = _completed;
    }

    public int getMaxUploads() {
        return this.maxUploads;
    }

    public int getEffectiveMaxUploads() {
        if (this.download_manager.isMaxUploadsWhenSeedingEnabled() && this.download_manager.getState() == 60) {
            return this.download_manager.getMaxUploadsWhenSeeding();
        }
        return this.maxUploads;
    }

    public void setMaxUploads(int i) {
        this.maxUploads = i;
    }

    public String getElapsedTime() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getElapsedTime();
        }
        return "";
    }

    public long getTimeStarted() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStarted();
        }
        return -1L;
    }

    public long getTimeStartedSeeding() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStartedSeeding();
        }
        return -1L;
    }

    public long getTotalDataBytesReceived() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_data_bytes_downloaded + pm.getStats().getTotalDataBytesReceived();
        }
        return this.saved_data_bytes_downloaded;
    }

    public long getTotalGoodDataBytesReceived() {
        long downloaded = this.getTotalDataBytesReceived();
        if ((downloaded -= this.getHashFailBytes() + this.getDiscarded()) < 0L) {
            downloaded = 0L;
        }
        return downloaded;
    }

    public long getTotalProtocolBytesReceived() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_protocol_bytes_downloaded + pm.getStats().getTotalProtocolBytesReceived();
        }
        return this.saved_protocol_bytes_downloaded;
    }

    public long getTotalDataBytesSent() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_data_bytes_uploaded + pm.getStats().getTotalDataBytesSent();
        }
        return this.saved_data_bytes_uploaded;
    }

    public long getTotalProtocolBytesSent() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_protocol_bytes_uploaded + pm.getStats().getTotalProtocolBytesSent();
        }
        return this.saved_protocol_bytes_uploaded;
    }

    public long getDiscarded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_discarded + pm.getStats().getTotalDiscarded();
        }
        return this.saved_discarded;
    }

    public long getHashFailCount() {
        TOTorrent t = this.download_manager.getTorrent();
        if (t == null) {
            return 0L;
        }
        long total = this.getHashFailBytes();
        long res = total / t.getPieceLength();
        if (res == 0L && total > 0L) {
            res = 1L;
        }
        return res;
    }

    public long getHashFailBytes() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_hashfails + pm.getStats().getTotalHashFailBytes();
        }
        return this.saved_hashfails;
    }

    public long getTotalAverage() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getTotalAverage();
        }
        return 0L;
    }

    public long getTotalAveragePerPeer() {
        int div = this.download_manager.getNbPeers() + (this.download_manager.isDownloadComplete() ? 0 : 1);
        long average = div < 1 ? 0L : this.getTotalAverage() / (long)div;
        return average;
    }

    public int getShareRatio() {
        long downloaded = this.getTotalGoodDataBytesReceived();
        long uploaded = this.getTotalDataBytesSent();
        if (downloaded <= 0L) {
            return -1;
        }
        return (int)(1000L * uploaded / downloaded);
    }

    public long getSecondsDownloading() {
        long lTimeStartedDL = this.getTimeStarted();
        if (lTimeStartedDL >= 0L) {
            long lTimeEndedDL = this.getTimeStartedSeeding();
            if (lTimeEndedDL == -1L) {
                lTimeEndedDL = SystemTime.getCurrentTime();
            }
            if (lTimeEndedDL > lTimeStartedDL) {
                return this.saved_SecondsDownloading + (lTimeEndedDL - lTimeStartedDL) / 1000L;
            }
        }
        return this.saved_SecondsDownloading;
    }

    public long getSecondsOnlySeeding() {
        long lTimeStarted = this.getTimeStartedSeeding();
        if (lTimeStarted >= 0L) {
            return this.saved_SecondsOnlySeeding + (SystemTime.getCurrentTime() - lTimeStarted) / 1000L;
        }
        return this.saved_SecondsOnlySeeding;
    }

    public float getAvailability() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return -1.0f;
        }
        return pm.getMinAvailability();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.max_upload_rate_bps;
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.max_upload_rate_bps = max_rate_bps;
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.max_download_rate_bps;
    }

    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.max_download_rate_bps = max_rate_bps;
    }

    protected void saveSessionTotals() {
        this.saved_data_bytes_downloaded = this.getTotalDataBytesReceived();
        this.saved_data_bytes_uploaded = this.getTotalDataBytesSent();
        this.saved_discarded = this.getDiscarded();
        this.saved_hashfails = this.getHashFailBytes();
        this.saved_SecondsDownloading = this.getSecondsDownloading();
        this.saved_SecondsOnlySeeding = this.getSecondsOnlySeeding();
    }

    protected void setSavedDownloadedUploaded(long d, long u) {
        this.saved_data_bytes_downloaded = d;
        this.saved_data_bytes_uploaded = u;
    }

    public void restoreSessionTotals(long _saved_data_bytes_downloaded, long _saved_data_bytes_uploaded, long _saved_discarded, long _saved_hashfails, long _saved_SecondsDownloading, long _saved_SecondsOnlySeeding) {
        this.saved_data_bytes_downloaded = _saved_data_bytes_downloaded;
        this.saved_data_bytes_uploaded = _saved_data_bytes_uploaded;
        this.saved_discarded = _saved_discarded;
        this.saved_hashfails = _saved_hashfails;
        this.saved_SecondsDownloading = _saved_SecondsDownloading;
        this.saved_SecondsOnlySeeding = _saved_SecondsOnlySeeding;
    }
}

