/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderReal;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class LocaleUtil {
    private static final String systemEncoding = System.getProperty("file.encoding");
    private static final String[] manual_charset = new String[]{systemEncoding, "Big5", "EUC-JP", "EUC-KR", "GB18030", "GB2312", "GBK", "ISO-2022-JP", "ISO-2022-KR", "Shift_JIS", "KOI8-R", "TIS-620", "UTF8", "windows-1251", "ISO-8859-1"};
    protected static final String[] generalCharsets = new String[]{"ISO-8859-1", "UTF8", systemEncoding};
    private static LocaleUtil singleton = new LocaleUtil();
    private LocaleUtilDecoder[] all_decoders;
    private LocaleUtilDecoder[] general_decoders;
    private LocaleUtilDecoder system_decoder;
    private LocaleUtilDecoder fallback_decoder;
    private List listeners = new ArrayList();

    public static LocaleUtil getSingleton() {
        return singleton;
    }

    private LocaleUtil() {
        int i;
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        ArrayList<String> decoder_names = new ArrayList<String>();
        for (i = 0; i < manual_charset.length; ++i) {
            try {
                String name = manual_charset[i];
                CharsetDecoder decoder = Charset.forName(name).newDecoder();
                if (decoder != null) {
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoder_names.add(lu_decoder.getName());
                    if (i == 0) {
                        this.system_decoder = lu_decoder;
                    }
                    decoders.add(lu_decoder);
                    continue;
                }
                if (i != 0) continue;
                Debug.out("System decoder failed to be found!!!!");
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.general_decoders = new LocaleUtilDecoder[generalCharsets.length];
        for (i = 0; i < this.general_decoders.length; ++i) {
            int gi = decoder_names.indexOf(generalCharsets[i]);
            if (gi == -1) continue;
            this.general_decoders[i] = (LocaleUtilDecoder)decoders.get(gi);
        }
        boolean show_all = COConfigurationManager.getBooleanParameter("File.Decoder.ShowAll");
        if (show_all) {
            SortedMap<String, Charset> m = Charset.availableCharsets();
            Iterator it = m.keySet().iterator();
            while (it.hasNext()) {
                String charset_name = (String)it.next();
                if (decoder_names.contains(charset_name)) continue;
                try {
                    CharsetDecoder decoder = Charset.forName(charset_name).newDecoder();
                    if (decoder == null) continue;
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoders.add(lu_decoder);
                    decoder_names.add(lu_decoder.getName());
                }
                catch (Exception ignore) {}
            }
        }
        this.fallback_decoder = new LocaleUtilDecoderFallback(decoders.size());
        decoders.add(this.fallback_decoder);
        this.all_decoders = new LocaleUtilDecoder[decoders.size()];
        decoders.toArray(this.all_decoders);
    }

    public String getSystemEncoding() {
        return systemEncoding;
    }

    public LocaleUtilDecoder[] getDecoders() {
        return this.all_decoders;
    }

    public LocaleUtilDecoder[] getGeneralDecoders() {
        return this.general_decoders;
    }

    public LocaleUtilDecoder getSystemDecoder() {
        return this.system_decoder;
    }

    protected LocaleUtilDecoderCandidate[] getCandidates(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[this.all_decoders.length];
        boolean show_less_likely_conversions = COConfigurationManager.getBooleanParameter("File.Decoder.ShowLax");
        for (int i = 0; i < this.all_decoders.length; ++i) {
            candidates[i] = new LocaleUtilDecoderCandidate(i);
            try {
                LocaleUtilDecoder decoder = this.all_decoders[i];
                String str = decoder.tryDecode(array, show_less_likely_conversions);
                if (str == null) continue;
                candidates[i].setDetails(decoder, str);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return candidates;
    }

    protected List getCandidateDecoders(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        for (int i = 0; i < candidates.length; ++i) {
            LocaleUtilDecoder d = candidates[i].getDecoder();
            if (d == null) continue;
            decoders.add(d);
        }
        return decoders;
    }

    protected List getCandidatesAsList(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoderCandidate> candidatesList = new ArrayList<LocaleUtilDecoderCandidate>();
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].getDecoder() == null) continue;
            candidatesList.add(candidates[i]);
        }
        return candidatesList;
    }

    public void addListener(LocaleUtilListener l) {
        this.listeners.add(l);
    }

    public void removeListener(LocaleUtilListener l) {
        this.listeners.remove(l);
    }

    public LocaleUtilDecoder getTorrentEncodingIfAvailable(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if (encoding != null) {
            String canonical_name;
            try {
                canonical_name = Charset.forName(encoding).name();
            }
            catch (Throwable e) {
                canonical_name = encoding;
            }
            for (int i = 0; i < this.all_decoders.length; ++i) {
                if (!this.all_decoders[i].getName().equals(canonical_name)) continue;
                return this.all_decoders[i];
            }
        }
        return null;
    }

    public LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        String encoding = torrent.getAdditionalStringProperty("encoding");
        boolean bSaveToFile = true;
        if (encoding != null) {
            try {
                String canonical_name = encoding.equals(this.fallback_decoder.getName()) ? encoding : Charset.forName(encoding).name();
                for (int i = 0; i < this.all_decoders.length; ++i) {
                    if (!this.all_decoders[i].getName().equals(canonical_name)) continue;
                    return this.all_decoders[i];
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        LocaleUtilDecoderCandidate[] candidates = this.getTorrentCandidates(torrent);
        boolean system_decoder_is_valid = false;
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].getDecoder() != this.system_decoder) continue;
            system_decoder_is_valid = true;
            break;
        }
        LocaleUtilDecoder selected_decoder = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            LocaleUtilDecoderCandidate candidate = ((LocaleUtilListener)this.listeners.get(i)).selectDecoder(this, torrent, candidates);
            if (candidate != null) {
                selected_decoder = candidate.getDecoder();
                break;
            }
            bSaveToFile = false;
        }
        if (selected_decoder == null) {
            selected_decoder = system_decoder_is_valid ? this.system_decoder : this.fallback_decoder;
        }
        torrent.setAdditionalStringProperty("encoding", selected_decoder.getName());
        if (bSaveToFile) {
            TorrentUtils.writeToFile(torrent);
        }
        return selected_decoder;
    }

    protected LocaleUtilDecoderCandidate[] getTorrentCandidates(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        byte[] created;
        HashSet cand_set = new HashSet();
        List candidateDecoders = this.getCandidateDecoders(torrent.getName());
        long lMinCandidates = candidateDecoders.size();
        byte[] minCandidatesArray = torrent.getName();
        cand_set.addAll(candidateDecoders);
        TOTorrentFile[] files = torrent.getFiles();
        for (int i = 0; i < files.length; ++i) {
            TOTorrentFile file = files[i];
            byte[][] comps = file.getPathComponents();
            for (int j = 0; j < comps.length; ++j) {
                candidateDecoders = this.getCandidateDecoders(comps[j]);
                if ((long)candidateDecoders.size() < lMinCandidates) {
                    lMinCandidates = candidateDecoders.size();
                    minCandidatesArray = comps[j];
                }
                cand_set.retainAll(candidateDecoders);
            }
        }
        byte[] comment = torrent.getComment();
        if (comment != null) {
            candidateDecoders = this.getCandidateDecoders(comment);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = comment;
            }
            cand_set.retainAll(candidateDecoders);
        }
        if ((created = torrent.getCreatedBy()) != null) {
            candidateDecoders = this.getCandidateDecoders(created);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = created;
            }
            cand_set.retainAll(candidateDecoders);
        }
        List candidatesList = this.getCandidatesAsList(minCandidatesArray);
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[candidatesList.size()];
        candidatesList.toArray(candidates);
        Arrays.sort(candidates, new Comparator(){

            public int compare(Object o1, Object o2) {
                LocaleUtilDecoderCandidate luc1 = (LocaleUtilDecoderCandidate)o1;
                LocaleUtilDecoderCandidate luc2 = (LocaleUtilDecoderCandidate)o2;
                return luc1.getDecoder().getIndex() - luc2.getDecoder().getIndex();
            }
        });
        return candidates;
    }

    public void setTorrentEncoding(TOTorrent torrent, String encoding) throws LocaleUtilEncodingException {
        try {
            String canonical_requested_name;
            LocaleUtilDecoderCandidate[] candidates = this.getTorrentCandidates(torrent);
            if (encoding.equalsIgnoreCase("system")) {
                canonical_requested_name = this.getSystemEncoding();
            } else if (encoding.equalsIgnoreCase(LocaleUtilDecoderFallback.NAME)) {
                canonical_requested_name = LocaleUtilDecoderFallback.NAME;
            } else {
                CharsetDecoder requested_decoder = Charset.forName(encoding).newDecoder();
                canonical_requested_name = requested_decoder.charset().name();
            }
            boolean ok = false;
            for (int i = 0; i < candidates.length; ++i) {
                if (!candidates[i].getDecoder().getName().equals(canonical_requested_name)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                String[] charsets = new String[candidates.length];
                String[] names = new String[candidates.length];
                for (int i = 0; i < candidates.length; ++i) {
                    LocaleUtilDecoder decoder = candidates[i].getDecoder();
                    charsets[i] = decoder.getName();
                    names[i] = decoder.decodeString(torrent.getName());
                }
                throw new LocaleUtilEncodingException(charsets, names);
            }
            torrent.setAdditionalStringProperty("encoding", canonical_requested_name);
        }
        catch (Throwable e) {
            if (e instanceof LocaleUtilEncodingException) {
                throw (LocaleUtilEncodingException)e;
            }
            throw new LocaleUtilEncodingException(e);
        }
    }

    public void setDefaultTorrentEncoding(TOTorrent torrent) throws LocaleUtilEncodingException {
        this.setTorrentEncoding(torrent, "UTF8");
    }

    public String getCurrentTorrentEncoding(TOTorrent torrent) {
        return torrent.getAdditionalStringProperty("encoding");
    }
}

