/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import java.net.URL;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerDHTAnnouncerImpl
extends TRTrackerAnnouncerImpl {
    private TOTorrent torrent;
    private byte[] torrent_hash;
    private byte[] data_peer_id;
    private String tracker_status_str;
    private long last_update_time;
    private int state = 1;
    private TRTrackerAnnouncerResponseImpl last_response;

    public TRTrackerDHTAnnouncerImpl(TOTorrent _torrent, String[] _networks) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        try {
            this.torrent_hash = this.torrent.getHash();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        try {
            this.data_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false);
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
        this.last_response = new TRTrackerAnnouncerResponseImpl(this.torrent.getAnnounceURL(), this.torrent_hash, 0, 0L, "Initialising");
        this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
    }

    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider provider) {
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public URL getTrackerUrl() {
        return this.torrent.getAnnounceURL();
    }

    public void setTrackerUrl(URL url) {
        Debug.out("setTrackerURL not supported for DHT");
    }

    public void resetTrackerUrl(boolean shuffle) {
    }

    public void setIPOverride(String override) {
    }

    public void clearIPOverride() {
    }

    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    public void setRefreshDelayOverrides(int percentage) {
    }

    public int getTimeUntilNextUpdate() {
        long elapsed = (SystemTime.getCurrentTime() - this.last_update_time) / 1000L;
        return (int)(this.last_response.getTimeToWait() - elapsed);
    }

    public int getLastUpdateTime() {
        return (int)(this.last_update_time / 1000L);
    }

    public void update(boolean force) {
        this.state = 2;
        this.checkCache();
    }

    public void complete(boolean already_reported) {
        this.state = 3;
    }

    public void stop() {
        this.state = 4;
    }

    public void destroy() {
    }

    public int getStatus() {
        return this.state;
    }

    public String getStatusString() {
        return this.tracker_status_str;
    }

    public TRTrackerAnnouncerResponse getLastResponse() {
        return this.last_response;
    }

    public void refreshListeners() {
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncerResponseImpl response;
        this.last_update_time = SystemTime.getCurrentTime();
        if (result.getResponseType() == 2) {
            this.tracker_status_str = MessageText.getString("PeerManager.status.error");
            String reason = result.getError();
            if (reason != null) {
                this.tracker_status_str = this.tracker_status_str + " (" + reason + ")";
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 0, result.getTimeToWait(), reason);
        } else {
            DownloadAnnounceResultPeer[] ext_peers = result.getPeers();
            TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeer[ext_peers.length];
            for (int i = 0; i < ext_peers.length; ++i) {
                DownloadAnnounceResultPeer ext_peer = ext_peers[i];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER DHT: ip=" + ext_peer.getAddress() + ",port=" + ext_peer.getPort() + ",prot=" + ext_peer.getProtocol()));
                }
                peers[i] = new TRTrackerAnnouncerResponsePeerImpl(ext_peer.getSource(), ext_peer.getPeerID(), ext_peer.getAddress(), ext_peer.getPort(), ext_peer.getProtocol());
            }
            this.addToTrackerCache(peers);
            this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 2, result.getTimeToWait(), peers);
        }
        this.last_response = response;
        this.listeners.dispatch(1, response);
    }

    protected void checkCache() {
        TRTrackerAnnouncerResponsePeer[] cached_peers;
        if (this.last_response.getStatus() != 2 && (cached_peers = this.getPeersFromCache(100)).length > 0) {
            this.last_response.setPeers(cached_peers);
            this.listeners.dispatch(1, this.last_response);
        }
    }
}

