/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.net.InetAddress;
import java.util.Arrays;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class TRTrackerServerPeerImpl
implements TRTrackerServerPeer,
HostNameToIPResolverListener,
TRTrackerServerNatCheckerListener {
    protected HashWrapper peer_id;
    protected int key_hash_code;
    protected byte[] ip;
    protected int port;
    protected String ip_str;
    protected byte[] ip_bytes;
    protected byte NAT_status = 0;
    protected long timeout;
    protected long uploaded;
    protected long downloaded;
    protected long amount_left;
    protected long last_contact_time;
    protected boolean download_completed;

    protected TRTrackerServerPeerImpl(HashWrapper _peer_id, int _key_hash_code, byte[] _ip, int _port, long _last_contact_time, boolean _download_completed, byte _last_nat_status) {
        this.peer_id = _peer_id;
        this.key_hash_code = _key_hash_code;
        this.ip = _ip;
        this.port = _port;
        this.last_contact_time = _last_contact_time;
        this.download_completed = _download_completed;
        this.NAT_status = _last_nat_status;
        this.resolveAndCheckNAT();
    }

    protected boolean checkForIPOrPortChange(byte[] _ip, int _port) {
        boolean res = false;
        if (_port != this.port) {
            this.port = _port;
            res = true;
        }
        if (!Arrays.equals(_ip, this.ip)) {
            this.ip = _ip;
            res = true;
        }
        if (res) {
            this.resolveAndCheckNAT();
        }
        return res;
    }

    public void NATCheckComplete(boolean ok) {
        this.NAT_status = ok ? (byte)3 : (byte)4;
    }

    protected void setNATStatus(byte status) {
        this.NAT_status = status;
    }

    public byte getNATStatus() {
        return this.NAT_status;
    }

    protected boolean isNATStatusBad() {
        return this.NAT_status == 4 || this.NAT_status == 5;
    }

    protected void resolveAndCheckNAT() {
        this.ip_str = new String(this.ip);
        this.ip_bytes = null;
        HostNameToIPResolver.addResolverRequest(this.ip_str, this);
        if (this.port == 0) {
            this.NAT_status = (byte)5;
        } else if (this.NAT_status == 0) {
            this.NAT_status = (byte)2;
            if (!TRTrackerServerNATChecker.getSingleton().addNATCheckRequest(this.ip_str, this.port, this)) {
                this.NAT_status = 1;
            }
        }
    }

    public void hostNameResolutionComplete(InetAddress address) {
        if (address != null) {
            this.ip_str = address.getHostAddress();
            this.ip_bytes = address.getAddress();
        }
    }

    protected long getLastContactTime() {
        return this.last_contact_time;
    }

    protected boolean getDownloadCompleted() {
        return this.download_completed;
    }

    protected void setDownloadCompleted() {
        this.download_completed = true;
    }

    protected HashWrapper getPeerId() {
        return this.peer_id;
    }

    protected int getKeyHashCode() {
        return this.key_hash_code;
    }

    protected byte[] getIPAsRead() {
        return this.ip;
    }

    public String getIPRaw() {
        return new String(this.ip);
    }

    public String getIP() {
        return this.ip_str;
    }

    public byte[] getIPBytes() {
        return this.ip_bytes;
    }

    protected int getPort() {
        return this.port;
    }

    protected void setTimeout(long _now, long _timeout) {
        this.last_contact_time = _now;
        this.timeout = _timeout;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected void setStats(long _uploaded, long _downloaded, long _amount_left) {
        this.uploaded = _uploaded;
        this.downloaded = _downloaded;
        this.amount_left = _amount_left;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getAmountLeft() {
        return this.amount_left;
    }

    protected boolean isSeed() {
        return this.amount_left == 0L;
    }

    protected String getString() {
        return new String(this.ip) + ":" + this.port + "(" + new String(this.peer_id.getHash()) + ")";
    }
}

