/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class BDecoder {
    protected static Charset BYTE_CHARSET;
    protected static Charset DEFAULT_CHARSET;
    private boolean recovery_mode;

    public static Map decode(byte[] data) throws IOException {
        return new BDecoder().decodeByteArray(data);
    }

    public static Map decode(BufferedInputStream is) throws IOException {
        return new BDecoder().decodeStream(is);
    }

    public Map decodeByteArray(byte[] data) throws IOException {
        return this.decode(new ByteArrayInputStream(data));
    }

    public Map decodeStream(BufferedInputStream data) throws IOException {
        Object res = this.decodeInputStream(data, 0);
        if (res == null) {
            throw new IOException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new IOException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    private Map decode(ByteArrayInputStream data) throws IOException {
        Object res = this.decodeInputStream(data, 0);
        if (res == null) {
            throw new IOException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new IOException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object decodeInputStream(InputStream bais, int nesting) throws IOException {
        if (!bais.markSupported()) {
            throw new IOException("InputStream must support the mark() method");
        }
        bais.mark(Integer.MAX_VALUE);
        int tempByte = bais.read();
        switch (tempByte) {
            case 100: {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                try {
                    byte[] tempByteArray = null;
                    while ((tempByteArray = (byte[])this.decodeInputStream(bais, nesting + 1)) != null) {
                        Object value = this.decodeInputStream(bais, nesting + 1);
                        CharBuffer cb = BYTE_CHARSET.decode(ByteBuffer.wrap(tempByteArray));
                        String key = new String(cb.array(), 0, cb.limit());
                        tempMap.put(key, value);
                    }
                    if (bais.available() >= nesting) return tempMap;
                    throw new IOException("BDecoder: invalid input data, 'e' missing from end of dictionary");
                }
                catch (Throwable e) {
                    if (this.recovery_mode) return tempMap;
                    if (!(e instanceof IOException)) throw new IOException(Debug.getNestedExceptionMessage(e));
                    throw (IOException)e;
                }
            }
            case 108: {
                ArrayList<Object> tempList = new ArrayList<Object>();
                try {
                    Object tempElement = null;
                    while ((tempElement = this.decodeInputStream(bais, nesting + 1)) != null) {
                        tempList.add(tempElement);
                    }
                    if (bais.available() >= nesting) return tempList;
                    throw new IOException("BDecoder: invalid input data, 'e' missing from end of list");
                }
                catch (Throwable e) {
                    if (this.recovery_mode) return tempList;
                    if (!(e instanceof IOException)) throw new IOException(Debug.getNestedExceptionMessage(e));
                    throw (IOException)e;
                }
            }
            case -1: 
            case 101: {
                return null;
            }
            case 105: {
                return new Long(this.getNumberFromStream(bais, 'e'));
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                bais.reset();
                return this.getByteArrayFromStream(bais);
            }
        }
        int rem_len = bais.available();
        if (rem_len > 256) {
            rem_len = 256;
        }
        byte[] rem_data = new byte[rem_len];
        bais.read(rem_data);
        throw new IOException("BDecoder: unknown command '" + tempByte + ", remainder = " + new String(rem_data));
    }

    private long getNumberFromStream(InputStream bais, char parseChar) throws IOException {
        int length = 0;
        bais.mark(Integer.MAX_VALUE);
        int tempByte = bais.read();
        while (tempByte != parseChar && tempByte >= 0) {
            tempByte = bais.read();
            ++length;
        }
        if (tempByte < 0) {
            return -1L;
        }
        bais.reset();
        byte[] tempArray = new byte[length];
        int len = 0;
        for (int count = 0; count != length && (len = bais.read(tempArray, count, length - count)) > 0; count += len) {
        }
        bais.skip(1L);
        CharBuffer cb = DEFAULT_CHARSET.decode(ByteBuffer.wrap(tempArray));
        String str_value = new String(cb.array(), 0, cb.limit());
        return Long.parseLong(str_value);
    }

    private byte[] getByteArrayFromStream(InputStream bais) throws IOException {
        int count;
        int length = (int)this.getNumberFromStream(bais, ':');
        if (length < 0) {
            return null;
        }
        if (length > 0x800000) {
            throw new IOException("Byte array length too large (" + length + ")");
        }
        byte[] tempArray = new byte[length];
        int len = 0;
        for (count = 0; count != length && (len = bais.read(tempArray, count, length - count)) > 0; count += len) {
        }
        if (count != tempArray.length) {
            throw new IOException("BDecoder::getByteArrayFromStream: truncated");
        }
        return tempArray;
    }

    public void setRecoveryMode(boolean r) {
        this.recovery_mode = r;
    }

    public void print(Object obj) {
        this.print(obj, "", false);
    }

    private void print(Object obj, String indent, boolean skip_indent) {
        String use_indent;
        String string = use_indent = skip_indent ? "" : indent;
        if (obj instanceof Long) {
            System.out.println(use_indent + obj);
        } else if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            System.out.println(use_indent + (b.length == 20 ? " { " + ByteFormatter.nicePrint(b) + " }" : new String(b)));
        } else if (obj instanceof String) {
            System.out.println(use_indent + obj);
        } else if (obj instanceof List) {
            List l = (List)obj;
            System.out.println(use_indent + "[");
            for (int i = 0; i < l.size(); ++i) {
                System.out.print(indent + "  (" + i + ") ");
                this.print(l.get(i), indent + "    ", true);
            }
            System.out.println(indent + "]");
        } else {
            Map m = (Map)obj;
            Iterator it = m.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                System.out.print(indent + key + " = ");
                this.print(m.get(key), indent + "  ", true);
            }
        }
    }

    public void print(File f) throws IOException {
        this.print(this.decodeStream(new BufferedInputStream(new FileInputStream(f))));
    }

    public static void main(String[] args) {
        try {
            BDecoder decoder = new BDecoder();
            decoder.setRecoveryMode(true);
            Map res = decoder.decodeStream(new BufferedInputStream(new FileInputStream(new File("C:\\temp\\scrape.php"))));
            decoder.print(res);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            BYTE_CHARSET = Charset.forName("ISO-8859-1");
            DEFAULT_CHARSET = Charset.forName("UTF8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

