/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Arrays;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;

public class HashWrapper
implements ByteArrayWrapper {
    private byte[] hash;
    private int hash_code;

    public HashWrapper(byte[] _hash) {
        this(_hash, 0, _hash.length);
    }

    public HashWrapper(byte[] _hash, int offset, int length) {
        this.hash = new byte[length];
        System.arraycopy(_hash, offset, this.hash, 0, length);
        for (int i = 0; i < length; ++i) {
            this.hash_code = 31 * this.hash_code + this.hash[i];
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HashWrapper)) {
            return false;
        }
        byte[] otherHash = ((HashWrapper)o).getHash();
        return Arrays.equals(this.hash, otherHash);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getBytes() {
        return this.hash;
    }

    public int hashCode() {
        return this.hash_code;
    }
}

