/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class PlatformManagerUpdateChecker
implements Plugin,
UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String UPDATE_NAME = "Platform-specific support";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected PluginInterface plugin_interface;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
        String version = "1.0";
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.getPlatformType() == 1) {
            if (platform.hasCapability(PlatformManagerCapabilities.GetVersion)) {
                try {
                    version = platform.getVersion();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        } else {
            this.plugin_interface.getPluginProperties().setProperty("plugin.version.info", "Not required for this platform");
        }
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", version);
    }

    public String getName() {
        return UPDATE_NAME;
    }

    public int getMaximumCheckTime() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(final UpdateChecker checker) {
        try {
            String sf_cvs_version;
            String sf_plugin_version;
            SFPluginDetails sf_details = SFPluginDetailsLoaderFactory.getSingleton().getPluginDetails(this.plugin_interface.getPluginID());
            String current_version = this.plugin_interface.getPluginVersion();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "PlatformManager:Win32 update check starts: current = " + current_version));
            }
            boolean current_az_is_cvs = Constants.isCVSVersion();
            String sf_comp_version = sf_plugin_version = sf_details.getVersion();
            if (current_az_is_cvs && (sf_cvs_version = sf_details.getCVSVersion()).length() > 0) {
                sf_plugin_version = sf_cvs_version;
                sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
            }
            String target_version = null;
            if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "PlatformManager:Win32 no valid version to check against (" + sf_comp_version + ")"));
                }
            } else if (Constants.compareVersions(current_version, sf_comp_version) < 0) {
                target_version = sf_comp_version;
            }
            checker.reportProgress("Win32: current = " + current_version + ", latest = " + sf_comp_version);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "PlatformManager:Win32 update required = " + (target_version != null)));
            }
            if (target_version != null) {
                String sf_cvs_version2;
                String target_download = sf_details.getDownloadURL();
                if (current_az_is_cvs && (sf_cvs_version2 = sf_details.getCVSVersion()).length() > 0) {
                    target_download = sf_details.getCVSDownloadURL();
                }
                ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                ResourceDownloader direct_rdl = rdf.create(new URL(target_download));
                String torrent_download = "http://torrents.aelitis.com:88/torrents/";
                int slash_pos = target_download.lastIndexOf("/");
                torrent_download = slash_pos == -1 ? torrent_download + target_download : torrent_download + target_download.substring(slash_pos + 1);
                torrent_download = torrent_download + ".torrent";
                ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl});
                rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                alternate_rdl.addListener(new ResourceDownloaderAdapter(){

                    public boolean completed(ResourceDownloader downloader, InputStream data) {
                        PlatformManagerUpdateChecker.this.installUpdate(checker, downloader, data);
                        return true;
                    }
                });
                ArrayList update_desc = new ArrayList();
                List desc_lines = HTMLUtils.convertHTMLToText("", sf_details.getDescription());
                update_desc.addAll(desc_lines);
                List comment_lines = HTMLUtils.convertHTMLToText("    ", sf_details.getComment());
                update_desc.addAll(comment_lines);
                String[] update_d = new String[update_desc.size()];
                update_desc.toArray(update_d);
                checker.addUpdate(UPDATE_NAME, update_d, target_version, alternate_rdl, 2);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            checker.failed();
        }
        finally {
            checker.completed();
        }
    }

    protected void installUpdate(UpdateChecker checker, ResourceDownloader rd, InputStream data) {
        try {
            UpdateInstaller installer = checker.createInstaller();
            ZipInputStream zip = new ZipInputStream(data);
            ZipEntry entry2 = null;
            while ((entry2 = zip.getNextEntry()) != null) {
                String name = entry2.getName();
                if (!name.toLowerCase().startsWith("windows/") || (name = name.substring(8)).length() <= 0) continue;
                rd.reportActivity("Adding update action for '" + name + "'");
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "PlatformManager:Win32 adding action for '" + name + "'"));
                }
                installer.addResource(name, zip, false);
                installer.addMoveAction(name, installer.getInstallDir() + File.separator + name);
            }
            zip.close();
        }
        catch (Throwable e) {
            rd.reportActivity("Update install failed:" + e.getMessage());
        }
    }

    protected List splitMultiLine(String indent, String text) {
        int p1;
        int pos = 0;
        String lc_text = text.toLowerCase();
        ArrayList<String> lines = new ArrayList<String>();
        do {
            String line;
            if ((p1 = lc_text.indexOf("<br>", pos)) == -1) {
                line = text.substring(pos);
            } else {
                line = text.substring(pos, p1);
                pos = p1 + 4;
            }
            lines.add(indent + line);
        } while (p1 != -1);
        return lines;
    }
}

