/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;

public class PeerStatsImpl
implements PeerStats {
    private PeerManagerImpl peer_manager;
    private PEPeerManager manager;
    private PEPeerStats delegate;
    private Peer owner;

    public PeerStatsImpl(PeerManagerImpl _peer_manager, Peer _owner, PEPeerStats _delegate) {
        this.peer_manager = _peer_manager;
        this.manager = this.peer_manager.getDelegate();
        this.delegate = _delegate;
        this.owner = _owner;
    }

    public PEPeerStats getDelegate() {
        return this.delegate;
    }

    public int getDownloadAverage() {
        return (int)this.delegate.getDataReceiveRate();
    }

    public int getReception() {
        return (int)this.delegate.getSmoothDataReceiveRate();
    }

    public int getUploadAverage() {
        return (int)this.delegate.getDataSendRate();
    }

    public int getTotalAverage() {
        return (int)this.delegate.getEstimatedDownloadRateOfPeer();
    }

    public long getTotalDiscarded() {
        return this.delegate.getTotalBytesDiscarded();
    }

    public long getTotalSent() {
        return this.delegate.getTotalDataBytesSent();
    }

    public long getTotalReceived() {
        return this.delegate.getTotalDataBytesReceived();
    }

    public int getStatisticSentAverage() {
        return (int)this.delegate.getEstimatedUploadRateOfPeer();
    }

    public void received(int bytes) {
        this.delegate.dataBytesReceived(bytes);
        this.manager.dataBytesReceived(bytes);
    }

    public void discarded(int bytes) {
        this.delegate.bytesDiscarded(bytes);
        this.manager.discarded(bytes);
    }

    public long getTimeSinceConnectionEstablished() {
        return this.peer_manager.getTimeSinceConnectionEstablished(this.owner);
    }
}

