/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.pluginsimpl.local.sharing.test.ShareTester;

public class ShareTester
implements Plugin,
PluginListener,
ShareManagerListener {
    protected static AESemaphore init_sem = new AESemaphore("ShareTester");
    private static AEMonitor class_mon = new AEMonitor("ShareTester");
    protected static ShareTester singleton;
    protected Map seed_transport_map = new HashMap();
    protected PluginInterface plugin_interface;
    static /* synthetic */ Class class$org$gudy$azureus2$pluginsimpl$local$sharing$test$ShareTester;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShareTester getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                new AEThread("plugin initialiser "){

                    public void runSupport() {
                        PluginManager.registerPlugin(class$org$gudy$azureus2$pluginsimpl$local$sharing$test$ShareTester == null ? (class$org$gudy$azureus2$pluginsimpl$local$sharing$test$ShareTester = ShareTester.class$("org.gudy.azureus2.pluginsimpl.local.sharing.test.ShareTester")) : class$org$gudy$azureus2$pluginsimpl$local$sharing$test$ShareTester);
                        Properties props = new Properties();
                        props.put("MULTI_INSTANCE", "true");
                        PluginManager.startAzureus(1, props);
                    }
                }.start();
                init_sem.reserve();
            }
            ShareTester shareTester = singleton;
            return shareTester;
        }
        finally {
            class_mon.exit();
        }
    }

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        singleton = this;
        init_sem.release();
        LoggerChannel log = this.plugin_interface.getLogger().getChannel("Plugin Test");
        log.log(1, "Plugin Initialised");
        this.plugin_interface.addListener(this);
    }

    public void initializationComplete() {
        try {
            DownloadManager dm = this.plugin_interface.getDownloadManager();
            dm.addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                    System.out.println("downloadAdded: " + download);
                    download.addListener(new DownloadListener(this, download){
                        private final /* synthetic */ Download val$download;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$download = val$download;
                        }

                        public void stateChanged(Download dl, int old, int cur) {
                            System.out.println("statechange:" + old + "-> " + cur + "  (" + this.val$download + ")");
                        }

                        public void positionChanged(Download download, int old, int cur) {
                            System.out.println("statechange:" + old + "-> " + cur + "  (" + download + ")");
                        }
                    });
                    download.addTrackerListener(new DownloadTrackerListener(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void scrapeResult(DownloadScrapeResult result) {
                            System.out.println("scrapeResult:" + result.getSeedCount() + "/" + result.getNonSeedCount());
                        }

                        public void announceResult(DownloadAnnounceResult result) {
                            if (result.getResponseType() == 1) {
                                System.out.println("announceResult:" + result.getReportedPeerCount() + "/" + result.getSeedCount() + "/" + result.getNonSeedCount());
                            } else {
                                System.out.println("announceResult:" + result.getError());
                            }
                        }
                    });
                    download.addPeerListener(new DownloadPeerListener(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void peerManagerAdded(Download download, PeerManager peer_manager) {
                            peer_manager.addListener(new PeerManagerListener(this){
                                private final /* synthetic */ 5 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void peerAdded(PeerManager manager, Peer peer) {
                                    System.out.println("peerAdded:" + peer.getIp());
                                }

                                public void peerRemoved(PeerManager manager, Peer peer) {
                                    System.out.println("peerRemoved:" + peer.getIp());
                                }
                            });
                        }

                        public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                        }
                    });
                }

                public void downloadRemoved(Download download) {
                    System.out.println("downloadRemoved" + download);
                }
            });
            ShareManager sm = this.plugin_interface.getShareManager();
            sm.addListener(this);
            sm.initialise();
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void closedownInitiated() {
    }

    public void closedownComplete() {
    }

    public void resourceAdded(ShareResource resource) {
        System.out.println("resource added:" + resource.getName());
        if (resource.getType() == 3) {
            ShareResourceDirContents c = (ShareResourceDirContents)resource;
            ShareResource[] kids = c.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                System.out.println("\t" + kids[i].getName());
            }
        }
    }

    public void resourceModified(ShareResource resource) {
        System.out.println("resource modified:" + resource.getName());
    }

    public void resourceDeleted(ShareResource resource) {
        System.out.println("resource deleted:" + resource.getName());
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(String task_description) {
        System.out.println(task_description);
    }

    public static void main(String[] args) {
        ShareTester.getSingleton();
    }
}

