/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.model;

import java.util.ArrayList;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.DirectoryParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterGroup;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ActionParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.LabelParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PasswordParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;

public class BasicPluginConfigModelImpl
implements BasicPluginConfigModel {
    private UIManagerImpl ui_manager;
    private String parent_section;
    private String section;
    private PluginInterface pi;
    private ArrayList parameters = new ArrayList();
    private String key_prefix;

    public BasicPluginConfigModelImpl(UIManagerImpl _ui_manager, String _parent_section, String _section) {
        this.ui_manager = _ui_manager;
        this.parent_section = _parent_section;
        this.section = _section;
        this.pi = this.ui_manager.getPluginInterface();
        this.key_prefix = this.pi.getPluginconfig().getPluginConfigKeyPrefix();
    }

    public String getParentSection() {
        return this.parent_section;
    }

    public String getSection() {
        return this.section;
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public Parameter[] getParameters() {
        Parameter[] res = new Parameter[this.parameters.size()];
        this.parameters.toArray(res);
        return res;
    }

    public void addBooleanParameter(String key, String resource_name, boolean defaultValue) {
        this.addBooleanParameter2(key, resource_name, defaultValue);
    }

    public BooleanParameter addBooleanParameter2(String key, String resource_name, boolean defaultValue) {
        BooleanParameterImpl res = new BooleanParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public void addStringParameter(String key, String resource_name, String defaultValue) {
        this.addStringParameter2(key, resource_name, defaultValue);
    }

    public StringParameter addStringParameter2(String key, String resource_name, String defaultValue) {
        StringParameterImpl res = new StringParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public StringListParameter addStringListParameter2(String key, String resource_name, String[] values, String defaultValue) {
        StringListParameterImpl res = new StringListParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, defaultValue, values, values);
        this.parameters.add(res);
        return res;
    }

    public StringListParameter addStringListParameter2(String key, String resource_name, String[] values, String[] labels, String defaultValue) {
        StringListParameterImpl res = new StringListParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, defaultValue, values, labels);
        this.parameters.add(res);
        return res;
    }

    public PasswordParameter addPasswordParameter2(String key, String resource_name, int encoding_type, byte[] defaultValue) {
        PasswordParameterImpl res = new PasswordParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, encoding_type, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public IntParameter addIntParameter2(String key, String resource_name, int defaultValue) {
        IntParameterImpl res = new IntParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public DirectoryParameter addDirectoryParameter2(String key, String resource_name, String defaultValue) {
        DirectoryParameterImpl res = new DirectoryParameterImpl(this.pi.getPluginconfig(), this.key_prefix + key, resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public LabelParameter addLabelParameter2(String resource_name) {
        LabelParameterImpl res = new LabelParameterImpl(this.pi.getPluginconfig(), this.key_prefix, resource_name);
        this.parameters.add(res);
        return res;
    }

    public ActionParameter addActionParameter2(String label_resource_name, String action_resource_name) {
        ActionParameterImpl res = new ActionParameterImpl(this.pi.getPluginconfig(), label_resource_name, action_resource_name);
        this.parameters.add(res);
        return res;
    }

    public ParameterGroup createGroup(String _resource_name, Parameter[] _parameters) {
        ParameterGroupImpl pg = new ParameterGroupImpl(_resource_name);
        for (int i = 0; i < _parameters.length; ++i) {
            ((ParameterImpl)_parameters[i]).setGroup(pg);
        }
        return pg;
    }

    public void destroy() {
        this.ui_manager.destroy(this);
    }
}

