/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public abstract class BufferedGraphicTableItem1
extends BufferedGraphicTableItem {
    private Image image;
    private boolean neverDrawn = true;

    public BufferedGraphicTableItem1(BufferedTableRow row, int position) {
        super(row, position);
    }

    public Image getGraphic() {
        return this.image;
    }

    public boolean setGraphic(Image img) {
        boolean bDoRedraw;
        boolean bImageSet = this.image != img;
        boolean bl = bDoRedraw = img == null;
        if (bImageSet) {
            if (!(bDoRedraw || this.image == null || this.image.isDisposed() || img.isDisposed() || this.image.getBounds().equals((Object)img.getBounds()))) {
                bDoRedraw = true;
            }
            this.image = img;
        }
        this.doPaint(bDoRedraw);
        return bImageSet;
    }

    public boolean needsPainting() {
        return true;
    }

    private void doPaint(boolean bForceClear) {
        if (this.image == null || this.image.isDisposed()) {
            return;
        }
        if (bForceClear || this.image.getImageData().getTransparencyType() != 0) {
            Table table = this.getTable();
            Rectangle bounds = this.getBoundsForCanvas();
            if (bounds == null) {
                return;
            }
            table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        } else {
            this.doPaint(null);
        }
    }

    public void doPaint(GC gc) {
        boolean ourGC;
        Rectangle bounds;
        if (this.neverDrawn) {
            if (gc == null) {
                return;
            }
            this.neverDrawn = false;
        }
        if ((bounds = this.getBoundsForCanvas()) == null || this.image == null || this.image.isDisposed()) {
            return;
        }
        Table table = this.getTable();
        Rectangle imageBounds = this.image.getBounds();
        if (imageBounds.width <= 0 || imageBounds.height <= 0 || bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        Rectangle tableBounds = table.getClientArea();
        if (bounds.y + bounds.height < table.getHeaderHeight() || bounds.y > tableBounds.height) {
            return;
        }
        if (this.orientation == 4) {
            if (!(Constants.isOSX || imageBounds.width == bounds.width && imageBounds.height == bounds.height)) {
                boolean ourGC2;
                boolean bl = ourGC2 = gc == null;
                if (ourGC2) {
                    gc = new GC((Drawable)table);
                }
                if (gc != null) {
                    int iAdj = VerticalAligner.getTableAdjustVerticalBy(table);
                    bounds.y += iAdj;
                    iAdj = VerticalAligner.getTableAdjustHorizontallyBy(table);
                    bounds.x += iAdj;
                    gc.drawImage(this.image, 0, 0, imageBounds.width, imageBounds.height, bounds.x, bounds.y, bounds.width, bounds.height);
                    if (ourGC2) {
                        gc.dispose();
                    }
                }
                this.invalidate();
                return;
            }
        } else if (imageBounds.width < bounds.width) {
            if (this.orientation == 0x1000000) {
                bounds.x += (bounds.width - imageBounds.width) / 2;
            } else if (this.orientation == 131072) {
                bounds.x = bounds.x + bounds.width - imageBounds.width;
            }
        }
        Rectangle clipping = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if (clipping.y < table.getHeaderHeight()) {
            clipping.height -= table.getHeaderHeight() - clipping.y;
            clipping.y = table.getHeaderHeight();
        }
        if (clipping.y + clipping.height > tableBounds.height) {
            clipping.height = tableBounds.height - clipping.y + 1;
        }
        if (clipping.width <= 0 && clipping.height <= 0) {
            return;
        }
        int iAdj = VerticalAligner.getTableAdjustVerticalBy(table);
        bounds.y += iAdj;
        clipping.y += iAdj;
        iAdj = VerticalAligner.getTableAdjustHorizontallyBy(table);
        bounds.x += iAdj;
        clipping.x += iAdj;
        boolean bl = ourGC = gc == null;
        if (ourGC && (gc = new GC((Drawable)table)) == null) {
            return;
        }
        gc.setClipping(clipping);
        gc.drawImage(this.image, bounds.x, bounds.y);
        if (ourGC) {
            gc.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        this.image = null;
    }

    public Rectangle getBoundsForCanvas() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        bounds.y += this.marginHeight;
        bounds.height -= this.marginHeight * 2;
        bounds.x += this.marginWidth;
        bounds.width -= this.marginWidth * 2;
        return bounds;
    }

    public Point getSize() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return new Point(0, 0);
        }
        return new Point(bounds.width - this.marginWidth * 2, bounds.height - this.marginHeight * 2);
    }

    public void invalidate() {
    }
}

