/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.utils.TableStructureEventDispatcher;

public class TableColumnImpl
implements TableColumnCore {
    private String sName;
    private String sTitleLanguageKey = null;
    private int iAlignment;
    private int iType;
    private int iPosition;
    private int iWidth;
    private int iInterval;
    private String sTableID;
    private boolean bColumnAdded;
    private boolean bCoreDataSource;
    private ArrayList cellRefreshListeners;
    private ArrayList cellAddedListeners;
    private ArrayList cellDisposeListeners;
    private ArrayList cellToolTipListeners;
    private ArrayList cellMouseListeners;
    private int iConsecutiveErrCount;
    private ArrayList menuItems;
    protected AEMonitor this_mon = new AEMonitor("TableColumn");

    public TableColumnImpl(String tableID, String columnID) {
        this.sTableID = tableID;
        this.sName = columnID;
        this.iType = 3;
        this.iPosition = -1;
        this.iWidth = 50;
        this.iAlignment = 1;
        this.bColumnAdded = false;
        this.bCoreDataSource = false;
        this.iInterval = -3;
        this.iConsecutiveErrCount = 0;
    }

    public void initialize(int iAlignment, int iPosition, int iWidth, int iInterval) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = iAlignment;
        this.iPosition = iPosition;
        this.iWidth = iWidth;
        this.iInterval = iInterval;
    }

    public void initialize(int iAlignment, int iPosition, int iWidth) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = iAlignment;
        this.iPosition = iPosition;
        this.iWidth = iWidth;
    }

    public String getName() {
        return this.sName;
    }

    public String getTableID() {
        return this.sTableID;
    }

    public void setType(int type) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iType = type;
    }

    public int getType() {
        return this.iType;
    }

    public void setWidth(int width) {
        if (width == this.iWidth || width < 0) {
            return;
        }
        this.iWidth = width;
        if (this.bColumnAdded && this.iPosition != -1) {
            TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
            tsed.columnSizeChanged(this);
            if (this.iType == 2) {
                this.invalidateCells();
            }
        }
    }

    public int getWidth() {
        return this.iWidth;
    }

    public void setPosition(int position) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iPosition = position;
    }

    public int getPosition() {
        return this.iPosition;
    }

    public void setAlignment(int alignment) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = alignment;
    }

    public int getAlignment() {
        return this.iAlignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                this.cellRefreshListeners = new ArrayList();
            }
            this.cellRefreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                return;
            }
            this.cellRefreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setRefreshInterval(int interval) {
        this.iInterval = interval;
    }

    public int getRefreshInterval() {
        return this.iInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellAddedListener(TableCellAddedListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                this.cellAddedListeners = new ArrayList();
            }
            this.cellAddedListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellAddedListener(TableCellAddedListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                return;
            }
            this.cellAddedListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellDisposeListeners == null) {
                this.cellDisposeListeners = new ArrayList();
            }
            this.cellDisposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellDisposeListeners == null) {
                return;
            }
            this.cellDisposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellToolTipListeners == null) {
                this.cellToolTipListeners = new ArrayList();
            }
            this.cellToolTipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellToolTipListeners == null) {
                return;
            }
            this.cellToolTipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList();
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void invalidateCells() {
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
        tsed.columnInvalidate(this);
    }

    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addCellDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addCellRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addCellToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellAddedListener) {
            this.addCellAddedListener((TableCellAddedListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addCellMouseListener((TableCellMouseListener)listenerObject);
        }
    }

    public void setColumnAdded(boolean bAdded) {
        this.bColumnAdded = bAdded;
    }

    public boolean getColumnAdded() {
        return this.bColumnAdded;
    }

    public void setUseCoreDataSource(boolean bCoreDataSource) {
        this.bCoreDataSource = bCoreDataSource;
    }

    public boolean getUseCoreDataSource() {
        return this.bCoreDataSource;
    }

    public void invokeCellRefreshListeners(TableCellCore cell) {
        if (this.cellRefreshListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellRefreshListeners.size(); ++i) {
            try {
                ((TableCellRefreshListener)this.cellRefreshListeners.get(i)).refresh(cell);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void invokeCellAddedListeners(TableCellCore cell) {
        if (this.cellAddedListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellAddedListeners.size(); ++i) {
            try {
                ((TableCellAddedListener)this.cellAddedListeners.get(i)).cellAdded(cell);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void invokeCellDisposeListeners(TableCellCore cell) {
        if (this.cellDisposeListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellDisposeListeners.size(); ++i) {
            try {
                ((TableCellDisposeListener)this.cellDisposeListeners.get(i)).dispose(cell);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void invokeCellToolTipListeners(TableCellCore cell, int type) {
        if (this.cellToolTipListeners == null) {
            return;
        }
        if (type == 0) {
            for (int i = 0; i < this.cellToolTipListeners.size(); ++i) {
                try {
                    ((TableCellToolTipListener)this.cellToolTipListeners.get(i)).cellHover(cell);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            for (int i = 0; i < this.cellToolTipListeners.size(); ++i) {
                try {
                    ((TableCellToolTipListener)this.cellToolTipListeners.get(i)).cellHoverComplete(cell);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void invokeCellMouseListeners(TableCellMouseEvent event) {
        if (this.cellMouseListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellMouseListeners.size(); ++i) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)this.cellMouseListeners.get(i);
                l.cellMouseTrigger(event);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setPositionNoShift(int position) {
        this.iPosition = position;
    }

    public void loadSettings() {
        String sItemPrefix = "Table." + this.sTableID + "." + this.sName;
        this.iWidth = COConfigurationManager.getIntParameter(sItemPrefix + ".width", this.iWidth);
        if (this.iWidth <= 0) {
            this.iWidth = 100;
        }
        this.iPosition = COConfigurationManager.getIntParameter(sItemPrefix + ".position", this.iPosition);
    }

    public void saveSettings() {
        String sItemPrefix = "Table." + this.sTableID + "." + this.sName;
        COConfigurationManager.setParameter(sItemPrefix + ".position", this.iPosition);
        COConfigurationManager.setParameter(sItemPrefix + ".width", this.iWidth);
    }

    public int getSWTAlign() {
        return this.iAlignment == 1 ? 16384 : (this.iAlignment == 3 ? 0x1000000 : 131072);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitleLanguageKey() {
        try {
            this.this_mon.enter();
            if (this.sTitleLanguageKey == null) {
                String sKeyPrefix;
                this.sTitleLanguageKey = this.sTableID + ".column." + this.sName;
                if (!MessageText.keyExists(this.sTitleLanguageKey) && MessageText.keyExists((sKeyPrefix = (this.sTableID.equals("MySeeders") ? "MyTorrents" : this.sTableID) + "View.") + this.sName)) {
                    this.sTitleLanguageKey = sKeyPrefix + this.sName;
                }
            }
            String string = this.sTitleLanguageKey;
            return string;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getConsecutiveErrCount() {
        return this.iConsecutiveErrCount;
    }

    public void setConsecutiveErrCount(int iCount) {
        this.iConsecutiveErrCount = iCount;
    }

    public void removeContextMenuItem(TableContextMenuItem menuItem) {
        if (this.menuItems == null) {
            return;
        }
        this.menuItems.remove(menuItem);
    }

    public TableContextMenuItem addContextMenuItem(String key) {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        TableContextMenuItemImpl item = new TableContextMenuItemImpl("", key);
        this.menuItems.add(item);
        return item;
    }

    public TableContextMenuItem[] getContextMenuItems() {
        if (this.menuItems == null) {
            return new TableContextMenuItem[0];
        }
        return this.menuItems.toArray(new TableContextMenuItem[0]);
    }
}

