/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import java.net.URL;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;

abstract class AbstractTrackerCell
implements TableCellRefreshListener,
TableCellToolTipListener,
TableCellDisposeListener,
DownloadManagerTrackerListener {
    TableCell cell;
    DownloadManager dm;

    public AbstractTrackerCell(TableCell cell) {
        this.cell = cell;
        cell.addListeners(this);
        this.dm = (DownloadManager)cell.getDataSource();
        if (this.dm == null) {
            return;
        }
        this.dm.addTrackerListener(this);
    }

    public void announceResult(TRTrackerAnnouncerResponse response) {
    }

    public boolean checkScrapeResult(TRTrackerScraperResponse response) {
        if (response != null && response.isValid()) {
            URL responseURL;
            DownloadManager dm = (DownloadManager)this.cell.getDataSource();
            if (dm == null || dm != this.dm) {
                return false;
            }
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) {
                return false;
            }
            URL announceURL = torrent.getAnnounceURL();
            if (announceURL != (responseURL = response.getURL()) && announceURL != null && responseURL != null && !announceURL.toString().equals(responseURL.toString())) {
                return false;
            }
            if (this.cell != null) {
                this.cell.invalidate();
            }
            return true;
        }
        return false;
    }

    public void refresh(TableCell cell) {
        DownloadManager oldDM = this.dm;
        this.dm = (DownloadManager)cell.getDataSource();
        if (this.dm != oldDM) {
            if (oldDM != null) {
                oldDM.removeTrackerListener(this);
            }
            if (this.dm != null) {
                this.dm.addTrackerListener(this);
            }
        }
    }

    public void cellHover(TableCell cell) {
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    public void dispose(TableCell cell) {
        DownloadManager dm;
        if (this.dm != null) {
            this.dm.removeTrackerListener(this);
        }
        if ((dm = (DownloadManager)cell.getDataSource()) != null && dm != this.dm) {
            dm.removeTrackerListener(this);
        }
        dm = null;
        cell = null;
    }
}

