/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.pieces;

import java.util.HashMap;
import java.util.Iterator;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class WritersItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public WritersItem() {
        super("writers", 1, -1, 80, "Pieces");
        this.setRefreshInterval(4);
    }

    public void refresh(TableCell cell) {
        PEPiece piece = (PEPiece)cell.getDataSource();
        String[] writers = piece.getWriters();
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < writers.length; ++i) {
            if (writers[i] == null) continue;
            String value = (String)map.get(writers[i]);
            value = value == null ? Integer.toString(i) : value + "," + i;
            map.put(writers[i], value);
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String writer = (String)iter.next();
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(writer);
            sb.append("[");
            sb.append((String)map.get(writer));
            sb.append("]");
        }
        String value = sb.toString();
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

