/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.control.DHTControlAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlFactory;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherFactory;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;

public class DHTImpl
implements DHT {
    private DHTStorageAdapter storage_adapter;
    private DHTNATPuncherAdapter nat_adapter;
    private DHTControl control;
    private DHTNATPuncher nat_puncher;
    private DHTSpeedTester speed_tester;
    private Properties properties;
    private DHTLogger logger;

    public DHTImpl(DHTTransport _transport, Properties _properties, DHTStorageAdapter _storage_adapter, DHTNATPuncherAdapter _nat_adapter, DHTLogger _logger) {
        this.properties = _properties;
        this.storage_adapter = _storage_adapter;
        this.nat_adapter = _nat_adapter;
        this.logger = _logger;
        DHTLog.setLogger(this.logger);
        int K = this.getProp("EntriesPerNode", 20);
        int B = this.getProp("NodeSplitFactor", 4);
        int max_r = this.getProp("ReplacementsPerNode", 5);
        int s_conc = this.getProp("SearchConcurrency", 5);
        int l_conc = this.getProp("LookupConcurrency", 10);
        int o_rep = this.getProp("OriginalRepublishInterval", 28800000);
        int c_rep = this.getProp("CacheRepublishInterval", 1800000);
        int c_n = this.getProp("CacheClosestN", 1);
        this.control = DHTControlFactory.create(new DHTControlAdapter(){

            public DHTStorageAdapter getStorageAdapter() {
                return DHTImpl.this.storage_adapter;
            }

            public boolean isDiversified(byte[] key) {
                if (DHTImpl.this.storage_adapter == null) {
                    return false;
                }
                return DHTImpl.this.storage_adapter.isDiversified(key);
            }

            public byte[][] diversify(DHTTransportContact cause, boolean put_operation, boolean existing, byte[] key, byte type, boolean exhaustive) {
                boolean valid;
                if (existing) {
                    valid = type == 2 || type == 3 || type == 1;
                } else {
                    boolean bl = valid = type == 2 || type == 3;
                }
                if (DHTImpl.this.storage_adapter != null && valid) {
                    if (existing) {
                        return DHTImpl.this.storage_adapter.getExistingDiversification(key, put_operation, exhaustive);
                    }
                    return DHTImpl.this.storage_adapter.createNewDiversification(cause, key, put_operation, type, exhaustive);
                }
                if (!valid) {
                    Debug.out("Invalid diversification received: type = " + type);
                }
                if (existing) {
                    return new byte[][]{key};
                }
                return new byte[0][];
            }
        }, _transport, K, B, max_r, s_conc, l_conc, o_rep, c_rep, c_n, this.logger);
        this.nat_puncher = DHTNATPuncherFactory.create(this.nat_adapter, this);
        this.speed_tester = DHTSpeedTesterFactory.create(this);
    }

    protected int getProp(String name, int def) {
        Integer x = (Integer)this.properties.get(name);
        if (x == null) {
            this.properties.put(name, new Integer(def));
            return def;
        }
        return x;
    }

    public int getIntProperty(String name) {
        return (Integer)this.properties.get(name);
    }

    public boolean isDiversified(byte[] key) {
        return this.control.isDiversified(key);
    }

    public void put(byte[] key, String description, byte[] value, byte flags, DHTOperationListener listener) {
        this.control.put(key, description, value, flags, listener);
    }

    public DHTTransportValue getLocalValue(byte[] key) {
        return this.control.getLocalValue(key);
    }

    public void get(byte[] key, String description, byte flags, int max_values, long timeout, boolean exhaustive, boolean high_priority, DHTOperationListener listener) {
        this.control.get(key, description, flags, max_values, timeout, exhaustive, high_priority, listener);
    }

    public byte[] remove(byte[] key, String description, DHTOperationListener listener) {
        return this.control.remove(key, description, listener);
    }

    public DHTTransport getTransport() {
        return this.control.getTransport();
    }

    public DHTRouter getRouter() {
        return this.control.getRouter();
    }

    public DHTControl getControl() {
        return this.control;
    }

    public DHTDB getDataBase() {
        return this.control.getDataBase();
    }

    public DHTNATPuncher getNATPuncher() {
        return this.nat_puncher;
    }

    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    public DHTStorageAdapter getStorageAdapter() {
        return this.storage_adapter;
    }

    public void integrate(boolean full_wait) {
        this.control.seed(full_wait);
        this.nat_puncher.start();
    }

    public void destroy() {
        this.nat_puncher.destroy();
    }

    public void exportState(DataOutputStream os, int max) throws IOException {
        this.control.exportState(os, max);
    }

    public void importState(DataInputStream is) throws IOException {
        this.control.importState(is);
    }

    public void setLogging(boolean on) {
        DHTLog.setLogging(on);
    }

    public DHTLogger getLogger() {
        return this.logger;
    }

    public void print() {
        this.control.print();
    }
}

