/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;

public class DownloadingRanker {
    public PEPeerTransport getNextOptimisticPeer(ArrayList all_peers) {
        return UnchokerUtil.getNextOptimisticPeer(all_peers, true, true);
    }

    public ArrayList rankPeers(int max_to_unchoke, ArrayList all_peers) {
        ArrayList best_peers = new ArrayList();
        long[] bests = new long[max_to_unchoke];
        for (int i = 0; i < all_peers.size(); ++i) {
            long rate;
            PEPeerTransport peer = (PEPeerTransport)all_peers.get(i);
            if (!peer.isInteresting() || !UnchokerUtil.isUnchokable(peer, false) || (rate = peer.getStats().getSmoothDataReceiveRate()) <= 256L) continue;
            UnchokerUtil.updateLargestValueFirstSort(rate, bests, peer, best_peers, 0);
        }
        if (best_peers.size() < max_to_unchoke) {
            int start_pos = best_peers.size();
            for (int i = 0; i < all_peers.size(); ++i) {
                long uploaded_ratio;
                PEPeerTransport peer = (PEPeerTransport)all_peers.get(i);
                if (!peer.isInteresting() || !UnchokerUtil.isUnchokable(peer, false) || best_peers.contains(peer) || (uploaded_ratio = peer.getStats().getTotalDataBytesSent() / (peer.getStats().getTotalDataBytesReceived() + 16383L)) >= 3L) continue;
                UnchokerUtil.updateLargestValueFirstSort(peer.getStats().getTotalDataBytesReceived(), bests, peer, best_peers, start_pos);
            }
        }
        return best_peers;
    }
}

