/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public abstract class TRTrackerAnnouncerImpl
implements TRTrackerAnnouncer {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    protected static final int LDT_TRACKER_RESPONSE = 1;
    protected static final int LDT_URL_CHANGED = 2;
    protected static final int LDT_URL_REFRESH = 3;
    protected ListenerManager listeners = ListenerManager.createManager("TrackerClient:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            TRTrackerAnnouncerListener listener = (TRTrackerAnnouncerListener)_listener;
            if (type == 1) {
                listener.receivedTrackerResponse((TRTrackerAnnouncerResponse)value);
            } else if (type == 2) {
                Object[] x = (Object[])value;
                String url = (String)x[0];
                boolean explicit = (Boolean)x[1];
                listener.urlChanged(url, explicit);
            } else {
                listener.urlRefresh();
            }
        }
    });
    private Map tracker_peer_cache = new LinkedHashMap();
    private AEMonitor tracker_peer_cache_mon = new AEMonitor("TRTrackerClientClassic:PC");

    public Map getTrackerResponseCache() {
        return this.exportTrackerCache();
    }

    public void setTrackerResponseCache(Map map) {
        int num = this.importTrackerCache(map);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: imported " + num + " cached peers"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map exportTrackerCache() {
        HashMap res = new HashMap();
        ArrayList peers = new ArrayList();
        res.put("tracker_peers", peers);
        try {
            this.tracker_peer_cache_mon.enter();
            for (TRTrackerAnnouncerResponsePeer peer : this.tracker_peer_cache.values()) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("ip", peer.getAddress().getBytes());
                entry.put("src", peer.getSource().getBytes());
                entry.put("port", new Long(peer.getPort()));
                int udp_port = peer.getUDPPort();
                if (udp_port != 0) {
                    entry.put("udpport", new Long(udp_port));
                }
                entry.put("prot", new Long(peer.getProtocol()));
                peers.add(entry);
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: exported " + this.tracker_peer_cache.size() + " cached peers"));
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
        return res;
    }

    protected byte[] getAnonymousPeerId(String my_ip, int my_port) {
        byte[] anon_peer_id = new byte[20];
        anon_peer_id[0] = 91;
        anon_peer_id[1] = 93;
        try {
            byte[] ip_bytes = my_ip.getBytes("UTF8");
            int ip_len = ip_bytes.length;
            if (ip_len > 18) {
                ip_len = 18;
            }
            System.arraycopy(ip_bytes, 0, anon_peer_id, 2, ip_len);
            int port_copy = my_port;
            for (int j = 2 + ip_len; j < 20; ++j) {
                anon_peer_id[j] = (byte)(port_copy & 0xFF);
                port_copy >>= 8;
            }
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
        return anon_peer_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int importTrackerCache(Map map) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return 0;
        }
        if (map == null) {
            return 0;
        }
        List peers = (List)map.get("tracker_peers");
        if (peers == null) {
            return 0;
        }
        try {
            this.tracker_peer_cache_mon.enter();
            for (int i = 0; i < peers.size(); ++i) {
                Map peer = (Map)peers.get(i);
                byte[] src_bytes = (byte[])peer.get("src");
                String peer_source = src_bytes == null ? "Tracker" : new String(src_bytes);
                String peer_ip_address = new String((byte[])peer.get("ip"));
                int peer_tcp_port = ((Long)peer.get("port")).intValue();
                byte[] peer_peer_id = this.getAnonymousPeerId(peer_ip_address, peer_tcp_port);
                Long l_protocol = (Long)peer.get("prot");
                short protocol = l_protocol == null ? (short)1 : l_protocol.shortValue();
                Long l_udp_port = (Long)peer.get("udpport");
                int peer_udp_port = l_udp_port == null ? 0 : l_udp_port.intValue();
                TRTrackerAnnouncerResponsePeerImpl entry = new TRTrackerAnnouncerResponsePeerImpl(peer_source, peer_peer_id, peer_ip_address, peer_tcp_port, peer_udp_port, protocol);
                this.tracker_peer_cache.put(entry.getKey(), entry);
            }
            int n = this.tracker_peer_cache.size();
            this.tracker_peer_cache_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.tracker_peer_cache_mon.exit();
                throw throwable;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return this.tracker_peer_cache.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] peers) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return;
        }
        int max = COConfigurationManager.getIntParameter("File.save.peers.max", 512);
        try {
            this.tracker_peer_cache_mon.enter();
            for (int i = 0; i < peers.length; ++i) {
                TRTrackerAnnouncerResponsePeerImpl peer = peers[i];
                this.tracker_peer_cache.remove(peer.getKey());
                this.tracker_peer_cache.put(peer.getKey(), peer);
            }
            Iterator it = this.tracker_peer_cache.keySet().iterator();
            if (max > 0) {
                while (this.tracker_peer_cache.size() > max) {
                    it.next();
                    it.remove();
                }
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTrackerResponseCache(String ip, int tcp_port) {
        try {
            this.tracker_peer_cache_mon.enter();
            TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("", new byte[0], ip, tcp_port, 0, 0);
            if (this.tracker_peer_cache.remove(peer.getKey()) != null && Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "Explicit removal of peer cache for " + ip + ":" + tcp_port));
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        List p2;
        if (map1 == null && map2 == null) {
            return new HashMap();
        }
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        HashMap res = new HashMap();
        ArrayList peers = (ArrayList)map1.get("tracker_peers");
        if (peers == null) {
            peers = new ArrayList();
        }
        if ((p2 = (List)map2.get("tracker_peers")) != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TRTrackerClient: merged peer sets: p1 = " + peers.size() + ", p2 = " + p2.size()));
            }
            for (int i = 0; i < p2.size(); ++i) {
                peers.add(p2.get(i));
            }
        }
        res.put("tracker_peers", peers);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int num_want) {
        try {
            TRTrackerAnnouncerResponsePeer[] res;
            this.tracker_peer_cache_mon.enter();
            if (this.tracker_peer_cache.size() <= num_want) {
                res = new TRTrackerAnnouncerResponsePeerImpl[this.tracker_peer_cache.size()];
                this.tracker_peer_cache.values().toArray(res);
            } else {
                int i;
                res = new TRTrackerAnnouncerResponsePeerImpl[num_want];
                Iterator it = this.tracker_peer_cache.keySet().iterator();
                for (i = 0; i < num_want; ++i) {
                    String key = (String)it.next();
                    res[i] = (TRTrackerAnnouncerResponsePeerImpl)this.tracker_peer_cache.get(key);
                    it.remove();
                }
                for (i = 0; i < num_want; ++i) {
                    this.tracker_peer_cache.put(((TRTrackerAnnouncerResponsePeerImpl)res[i]).getKey(), res[i]);
                }
            }
            if (Logger.isEnabled()) {
                for (int i = 0; i < res.length; ++i) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "CACHED PEER: " + ((TRTrackerAnnouncerResponsePeerImpl)res[i]).getString()));
                }
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: returned " + res.length + " cached peers"));
            }
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = res;
            return tRTrackerAnnouncerResponsePeerArray;
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    public void addListener(TRTrackerAnnouncerListener l) {
        this.listeners.addListener(l);
    }

    public void removeListener(TRTrackerAnnouncerListener l) {
        this.listeners.removeListener(l);
    }
}

