/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerStatus;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TrackerChecker
implements AEDiagnosticsEvidenceGenerator,
SystemTime.consumer {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private HashMap trackers;
    private AEMonitor trackers_mon = new AEMonitor("TrackerChecker:trackers");
    private TRTrackerBTScraperImpl scraper;
    private long nextScrapeCheckOn;

    protected TrackerChecker(TRTrackerBTScraperImpl _scraper) {
        this.scraper = _scraper;
        this.trackers = new HashMap();
        AEThread t = new AEThread("Tracker Scrape"){

            public void runSupport() {
                TrackerChecker.this.runScrapes();
            }
        };
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
        AEDiagnostics.addEvidenceGenerator(this);
        SystemTime.registerClockChangeListener(this);
    }

    protected TRTrackerScraperResponseImpl getHashData(TRTrackerAnnouncer tracker_client) {
        try {
            return this.getHashData(tracker_client.getTrackerUrl(), tracker_client.getTorrent().getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(TOTorrent torrent, URL target_url) {
        try {
            return this.getHashData(target_url == null ? torrent.getAnnounceURL() : target_url, torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl getHashData(URL trackerUrl, HashWrapper hash) {
        if (trackerUrl == null) {
            return null;
        }
        TRTrackerScraperResponseImpl data = null;
        String url_str = trackerUrl.toString();
        try {
            this.trackers_mon.enter();
            TrackerStatus ts = (TrackerStatus)this.trackers.get(url_str);
            if (ts != null) {
                data = ts.getHashData(hash);
                if (data == null) {
                    data = ts.addHash(hash);
                }
            } else {
                ts = new TrackerStatus(this, this.scraper.getScraper(), trackerUrl);
                this.trackers.put(url_str, ts);
                data = ts.addHash(hash);
                if (!ts.isTrackerScrapeUrlValid() && Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 3, "Can't scrape using url '" + trackerUrl + "' as it doesn't end in " + "'/announce', skipping."));
                }
            }
        }
        finally {
            this.trackers_mon.exit();
        }
        return data;
    }

    protected void removeHash(TOTorrent torrent) {
        try {
            this.removeHash(torrent.getAnnounceURL().toString(), torrent.getHashWrapper());
            TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
            for (int i = 0; i < sets.length; ++i) {
                URL[] urls = sets[i].getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    this.removeHash(urls[j].toString(), torrent.getHashWrapper());
                }
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void removeHash(String trackerUrl, HashWrapper hash) {
        TrackerStatus ts = (TrackerStatus)this.trackers.get(trackerUrl);
        if (ts != null) {
            ts.removeHash(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncUpdate(TOTorrent torrent, URL target_url) {
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hash = torrent.getHashWrapper();
            TrackerStatus matched_ts = null;
            try {
                this.trackers_mon.enter();
                for (TrackerStatus ts : this.trackers.values()) {
                    if (target_url != null && !target_url.toString().equals(ts.getTrackerURL().toString())) continue;
                    Map hashmap = ts.getHashes();
                    try {
                        ts.getHashesMonitor().enter();
                        if (hashmap.get(hash) == null) continue;
                        matched_ts = ts;
                        break;
                    }
                    finally {
                        ts.getHashesMonitor().exit();
                    }
                }
            }
            finally {
                this.trackers_mon.exit();
            }
            if (matched_ts != null) {
                matched_ts.updateSingleHash(hash, true, false);
            }
        }
        catch (Throwable e) {
            Debug.out("scrape syncUpdate() exception", e);
        }
    }

    private void runScrapes() {
        TRTrackerScraperResponseImpl next_response_to_scrape = null;
        while (true) {
            long delay;
            if (next_response_to_scrape == null) {
                delay = 60000L;
            } else {
                long scrape_time = next_response_to_scrape.getNextScrapeStartTime();
                long time_to_scrape = scrape_time - SystemTime.getCurrentTime();
                if (time_to_scrape <= 0L) {
                    try {
                        ((TRTrackerBTScraperResponseImpl)next_response_to_scrape).getTrackerStatus().updateSingleHash(next_response_to_scrape.getHash(), false);
                        delay = 250L;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        delay = 30000L;
                    }
                } else {
                    delay = time_to_scrape;
                    if (delay > 30000L) {
                        delay = 30000L;
                    }
                }
            }
            try {
                this.nextScrapeCheckOn = SystemTime.getCurrentTime() + delay;
                Thread.sleep(delay);
            }
            catch (Exception e) {
                // empty catch block
            }
            next_response_to_scrape = this.checkForNextScrape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TRTrackerBTScraperResponseImpl checkForNextScrape() {
        TRTrackerBTScraperResponseImpl next_response_to_scrape = null;
        long earliest = Long.MAX_VALUE;
        try {
            this.trackers_mon.enter();
            for (TrackerStatus ts : this.trackers.values()) {
                if (!ts.isTrackerScrapeUrlValid()) continue;
                Map hashmap = ts.getHashes();
                try {
                    ts.getHashesMonitor().enter();
                    for (TRTrackerBTScraperResponseImpl response : hashmap.values()) {
                        if (response.getStatus() == 3 || response.getNextScrapeStartTime() >= earliest) continue;
                        earliest = response.getNextScrapeStartTime();
                        next_response_to_scrape = response;
                    }
                }
                finally {
                    ts.getHashesMonitor().exit();
                }
            }
        }
        finally {
            this.trackers_mon.exit();
        }
        return next_response_to_scrape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(long offset) {
        if (Math.abs(offset) < 60000L) {
            return;
        }
        try {
            this.trackers_mon.enter();
            for (TrackerStatus ts : this.trackers.values()) {
                Map hashmap = ts.getHashes();
                try {
                    ts.getHashesMonitor().enter();
                    for (TRTrackerBTScraperResponseImpl response : hashmap.values()) {
                        long time = response.getNextScrapeStartTime();
                        if (time <= 0L) continue;
                        response.setNextScrapeStartTime(time + offset);
                    }
                }
                finally {
                    ts.getHashesMonitor().exit();
                }
            }
        }
        finally {
            this.trackers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("BTScraper - now = " + SystemTime.getCurrentTime());
        try {
            writer.indent();
            try {
                this.trackers_mon.enter();
                for (Map.Entry entry : this.trackers.entrySet()) {
                    TrackerStatus ts = (TrackerStatus)entry.getValue();
                    writer.println("Tracker: " + ts.getString());
                    try {
                        writer.indent();
                        ts.getHashesMonitor().enter();
                        Map hashmap = ts.getHashes();
                        for (Map.Entry hash_entry : hashmap.entrySet()) {
                            TRTrackerBTScraperResponseImpl response = (TRTrackerBTScraperResponseImpl)hash_entry.getValue();
                            writer.println(response.getString());
                        }
                    }
                    finally {
                        ts.getHashesMonitor().exit();
                        writer.exdent();
                    }
                }
            }
            finally {
                this.trackers_mon.exit();
            }
        }
        finally {
            writer.exdent();
        }
    }

    public long getNextScrapeCheckOn() {
        return this.nextScrapeCheckOn;
    }
}

