/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderRetryImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloaderBaseImpl delegate;
    protected int retry_count;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected int done_count;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDRretry");
    protected long size = -2L;

    public ResourceDownloaderRetryImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader _delegate, int _retry_count) {
        super(_parent);
        this.delegate = (ResourceDownloaderBaseImpl)_delegate;
        this.delegate.setParent(this);
        this.retry_count = _retry_count;
    }

    public String getName() {
        return this.delegate.getName() + ", retry=" + this.retry_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size != -2L) {
            return this.size;
        }
        try {
            for (int i = 0; i < this.retry_count; ++i) {
                try {
                    ResourceDownloaderBaseImpl c = this.delegate.getClone(this);
                    this.addReportListener(c);
                    this.size = c.getSize();
                    this.setProperties(c);
                    long l = this.size;
                    return l;
                }
                catch (ResourceDownloaderException e) {
                    try {
                        if (i != this.retry_count - 1) continue;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return this.size;
                    }
                }
            }
        }
        finally {
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    protected void setProperty(String name, Object value) {
        this.setPropertySupport(name, value);
        this.delegate.setProperty(name, value);
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderRetryImpl c = new ResourceDownloaderRetryImpl(parent, this.delegate.getClone(this), this.retry_count);
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.done_count == this.retry_count || this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                ++this.done_count;
                if (this.done_count > 1) {
                    this.informActivity(this.getLogIndent() + "  attempt " + this.done_count + " of " + this.retry_count);
                }
                this.current_downloader = this.delegate.getClone(this);
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderException("Download cancelled");
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        if (this.informComplete(data)) {
            this.result = data;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.asyncDownload();
    }
}

