/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BufferedTableRow {
    private static final int VALUE_SIZE_INC = 8;
    private static Color[] alternatingColors = null;
    public static final int REQUIRE_TABLEITEM = 0;
    public static final int REQUIRE_TABLEITEM_INITIALIZED = 1;
    public static final int REQUIRE_VISIBILITY = 2;
    protected Table table;
    protected TableItem item;
    protected Image[] image_values = new Image[0];
    protected Color[] foreground_colors = new Color[0];
    protected Color foreground;
    private static final boolean bDebug = false;
    private Point ptIconSize = null;

    public BufferedTableRow(Table _table) {
        this.table = _table;
        this.item = null;
    }

    public void createSWTRow() {
        this.item = new TableItem(this.table, 0);
        this.setAlternatingBGColor(true);
    }

    public void createSWTRow(int index) {
        new TableItem(this.table, 0);
        this.setTableItem(index, false);
    }

    public void setAlternatingBGColor(boolean bEvenIfNotVisible) {
        Color newColor;
        if (Utils.TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            return;
        }
        if ((this.table.getStyle() & 0x10000000) != 0 && !bEvenIfNotVisible && !this.isVisible()) {
            return;
        }
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        int index = this.table.indexOf(this.item);
        if (index == -1) {
            return;
        }
        if (alternatingColors == null || alternatingColors[1].isDisposed()) {
            alternatingColors = new Color[]{this.table.getDisplay().getSystemColor(25), Colors.colorAltRow};
        }
        if (!(newColor = alternatingColors[index % alternatingColors.length]).equals((Object)this.getBackground())) {
            this.item.setBackground(newColor);
        }
    }

    public void dispose() {
        if (this.table != null && !this.table.isDisposed() && Utils.isThisThreadSWT()) {
            if (!this.checkWidget(0)) {
                TableItem[] items = this.table.getItems();
                for (int i = items.length - 1; i >= 0; --i) {
                    Object itemRow;
                    TableItem item = items[i];
                    if (item.isDisposed() || (itemRow = item.getData("TableRow")) != null && itemRow != this) continue;
                    this.item = item;
                    break;
                }
            }
            if (this.item != null && !this.item.isDisposed()) {
                this.item.dispose();
            } else if (this.table.getItemCount() > 0) {
                System.err.println("No table row was found to dispose");
            }
        } else if (!Utils.isThisThreadSWT()) {
            System.err.println("Calling BufferedTableRow.dispose on non-SWT thread!");
            System.err.println(Debug.getStackTrace(false, false));
        }
        this.item = null;
    }

    public void setImage(int index, Image new_image) {
        Image image;
        if (!this.checkWidget(1)) {
            return;
        }
        if (index >= this.image_values.length) {
            int new_size = Math.max(index + 1, this.image_values.length + 8);
            Image[] new_images = new Image[new_size];
            System.arraycopy(this.image_values, 0, new_images, 0, this.image_values.length);
            this.image_values = new_images;
        }
        if (new_image == (image = this.image_values[index])) {
            return;
        }
        this.image_values[index] = new_image;
        this.item.setImage(index, new_image);
    }

    public boolean checkWidget(int checkFlags) {
        boolean bCheckInitialized;
        boolean bWidgetOk = !this.table.isDisposed() && this.item != null && !this.item.isDisposed() && this.item.getData("TableRow") == this;
        boolean bCheckVisibility = (checkFlags & 2) > 0;
        boolean bl = bCheckInitialized = (checkFlags & 1) > 0;
        if (bWidgetOk && bCheckInitialized) {
            boolean bl2 = bWidgetOk = (this.table.getStyle() & 0x10000000) == 0 || this.item.getData("SD") != null;
        }
        if (bWidgetOk && bCheckVisibility) {
            if (this._isVisible()) {
                if (!bCheckInitialized && (this.table.getStyle() & 0x10000000) != 0 && this.item.getData("SD") == null) {
                    try {
                        this.item.setData("SD", (Object)"1");
                    }
                    catch (NullPointerException badSWT) {
                        // empty catch block
                    }
                    this.setAlternatingBGColor(true);
                    this.setIconSize(this.ptIconSize);
                    this.invalidate();
                }
            } else {
                bWidgetOk = false;
            }
        }
        return bWidgetOk;
    }

    private boolean _isVisible() {
        int index = this.table.indexOf(this.item);
        if (index == -1) {
            return false;
        }
        int iTopIndex = this.table.getTopIndex();
        if (index < iTopIndex) {
            return false;
        }
        int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
        return index <= iBottomIndex;
    }

    public Color getForeground() {
        if (!this.checkWidget(1)) {
            return null;
        }
        return this.item.getForeground();
    }

    public void setForeground(Color c) {
        if (!this.checkWidget(1)) {
            return;
        }
        if (this.foreground != null && this.foreground.equals((Object)c)) {
            return;
        }
        this.foreground = c;
        this.item.setForeground(this.foreground);
    }

    public boolean setForeground(int index, Color new_color) {
        Color value;
        if (!this.checkWidget(1)) {
            return false;
        }
        if (index >= this.foreground_colors.length) {
            int new_size = Math.max(index + 1, this.foreground_colors.length + 8);
            Color[] new_colors = new Color[new_size];
            System.arraycopy(this.foreground_colors, 0, new_colors, 0, this.foreground_colors.length);
            this.foreground_colors = new_colors;
        }
        if (new_color == (value = this.foreground_colors[index])) {
            return false;
        }
        if (new_color != null && value != null && new_color.equals((Object)value)) {
            return false;
        }
        this.foreground_colors[index] = new_color;
        try {
            this.item.setForeground(index, new_color);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return true;
    }

    public Color getForeground(int index) {
        if (!this.checkWidget(1)) {
            return null;
        }
        if (index >= this.foreground_colors.length) {
            return this.item.getForeground();
        }
        return this.foreground_colors[index];
    }

    protected String getText(int index) {
        if (!this.checkWidget(1)) {
            return "";
        }
        return this.item.getText(index);
    }

    public boolean setText(int index, String new_value) {
        if (!this.checkWidget(1)) {
            return false;
        }
        if (index < 0 || index >= this.table.getColumnCount()) {
            return false;
        }
        if (new_value == null) {
            new_value = "";
        }
        if (this.item.getText(index).equals(new_value)) {
            return false;
        }
        this.item.setText(index, new_value);
        return true;
    }

    public Rectangle getBounds(int index) {
        if (!this.checkWidget(1)) {
            return null;
        }
        if (this.table.indexOf(this.item) == -1) {
            return null;
        }
        Rectangle r = this.item.getBounds(index);
        if (r == null || r.width == 0 || r.height == 0) {
            return null;
        }
        return r;
    }

    protected Table getTable() {
        return this.table;
    }

    public Color getBackground() {
        if (!this.checkWidget(1)) {
            return null;
        }
        return this.item.getBackground();
    }

    public int getIndex() {
        if (!this.checkWidget(0)) {
            return -1;
        }
        return this.table.indexOf(this.item);
    }

    private void copyToItem(TableItem newItem) {
        Table table = this.getTable();
        if (table == null || this.item == null) {
            return;
        }
        newItem.setImage(this.image_values);
        Color colorFG = this.item.getForeground();
        Color colorBG = this.item.getBackground();
        newItem.setForeground(colorFG);
        newItem.setBackground(colorBG);
        int numColumns = table.getColumnCount();
        for (int i = 0; i < numColumns; ++i) {
            try {
                newItem.setText(i, this.item.getText(i));
                Color colorColumnFG = this.item.getForeground(i);
                Color colorColumnBG = this.item.getBackground(i);
                if (!colorColumnFG.equals((Object)colorFG)) {
                    newItem.setForeground(i, colorColumnFG);
                }
                if (colorColumnBG.equals((Object)colorBG)) continue;
                newItem.setBackground(i, colorColumnBG);
                continue;
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
        }
        if (this.isSelected()) {
            table.select(table.indexOf(newItem));
        } else {
            table.deselect(table.indexOf(newItem));
        }
        newItem.setData("TableRow", this.item.getData("TableRow"));
    }

    public boolean isSelected() {
        if (!this.checkWidget(0)) {
            return false;
        }
        return this.table.isSelected(this.table.indexOf(this.item));
    }

    public void setSelected(boolean bSelected) {
        if (!this.checkWidget(0)) {
            return;
        }
        if (bSelected) {
            this.table.select(this.getIndex());
        } else {
            this.table.deselect(this.getIndex());
        }
    }

    public boolean setTableItem(int newIndex, boolean bCopyFromOld) {
        TableItem newRow;
        block17: {
            try {
                newRow = this.table.getItem(newIndex);
            }
            catch (IllegalArgumentException er) {
                if (this.item == null || this.item.isDisposed()) {
                    return false;
                }
                this.item = null;
                return true;
            }
            catch (Throwable e) {
                System.out.println("setTableItem(" + newIndex + ", " + bCopyFromOld + ")");
                e.printStackTrace();
                return false;
            }
            if (newRow == this.item && (newRow == null || newRow.getData("TableRow") == this)) {
                this.setAlternatingBGColor(false);
                return false;
            }
            if (newRow != null) {
                if (newRow.getParent() != this.table) {
                    return false;
                }
                if (bCopyFromOld) {
                    this.copyToItem(newRow);
                } else if (newRow.getData("SD") != null) {
                    newRow.setForeground(null);
                    int numColumns = this.table.getColumnCount();
                    for (int i = 0; i < numColumns; ++i) {
                        try {
                            newRow.setForeground(i, null);
                            continue;
                        }
                        catch (NoSuchMethodError e) {
                            // empty catch block
                        }
                    }
                } else {
                    newRow.setData("SD", (Object)"1");
                }
                this.setAlternatingBGColor(false);
                try {
                    newRow.setData("TableRow", (Object)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Disposed? " + newRow.isDisposed());
                    if (newRow.isDisposed()) break block17;
                    System.out.println("TR? " + newRow.getData("TableRow"));
                    System.out.println("SD? " + newRow.getData("SD"));
                }
            }
        }
        this.image_values = new Image[0];
        this.foreground_colors = new Color[0];
        this.foreground = null;
        if (this.item != null && !this.item.isDisposed() && this.item.getData("TableRow") == this) {
            this.item.setData("TableRow", null);
        }
        this.item = newRow;
        this.invalidate();
        return true;
    }

    public boolean setHeight(int iHeight) {
        return this.setIconSize(new Point(1, iHeight));
    }

    public boolean setIconSize(Point pt) {
        this.ptIconSize = pt;
        if (pt == null) {
            return false;
        }
        if (!this.checkWidget(1)) {
            return false;
        }
        Image oldImage = this.item.getImage(0);
        if (oldImage != null) {
            Rectangle r = oldImage.getBounds();
            if (r.width == pt.x && r.height == pt.y) {
                return false;
            }
        }
        Image image = new Image((Device)this.item.getDisplay(), pt.x, pt.y);
        this.item.setImage(0, image);
        this.item.setImage(0, null);
        image.dispose();
        return true;
    }

    public boolean isVisible() {
        return this.checkWidget(2);
    }

    public void invalidate() {
        if (!this.checkWidget(3)) {
            return;
        }
        Rectangle r = this.item.getBounds(0);
        this.table.redraw(0, r.y, this.table.getClientArea().width, r.height, true);
    }
}

