/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericBooleanParameter {
    GenericParameterAdapter adapter;
    String name;
    Button checkBox;
    boolean defaultValue;
    List performers = new ArrayList();

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name) {
        this(adapter, composite, name, adapter.getBooleanValue(name), null, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name, String textKey) {
        this(adapter, composite, name, adapter.getBooleanValue(name), textKey, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name, boolean defaultValue, String textKey) {
        this(adapter, composite, name, defaultValue, textKey, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name, boolean defaultValue) {
        this(adapter, composite, name, defaultValue, null, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter _adapter, Composite composite, String _name, boolean _defaultValue, String textKey, IAdditionalActionPerformer actionPerformer) {
        this.adapter = _adapter;
        this.name = _name;
        this.defaultValue = _defaultValue;
        if (actionPerformer != null) {
            this.performers.add(actionPerformer);
        }
        boolean value = this.adapter.getBooleanValue(this.name, this.defaultValue);
        this.checkBox = new Button(composite, 32);
        if (textKey != null) {
            Messages.setLanguageText((Widget)this.checkBox, textKey);
        }
        this.checkBox.setSelection(value);
        this.checkBox.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                GenericBooleanParameter.this.setSelected(GenericBooleanParameter.this.checkBox.getSelection(), true);
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.checkBox.setLayoutData(layoutData);
    }

    public void setAdditionalActionPerformer(IAdditionalActionPerformer actionPerformer) {
        this.performers.add(actionPerformer);
        boolean selected = this.checkBox.getSelection();
        actionPerformer.setSelected(selected);
        actionPerformer.performAction();
    }

    public Control getControl() {
        return this.checkBox;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isSelected() {
        return this.checkBox.getSelection();
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, false);
    }

    public void setValue(boolean b) {
        this.setSelected(b);
    }

    protected void setSelected(boolean selected, boolean force) {
        if (selected != this.checkBox.getSelection() || force) {
            this.adapter.setBooleanValue(this.name, selected);
            this.checkBox.setSelection(selected);
            if (this.performers.size() > 0) {
                for (int i = 0; i < this.performers.size(); ++i) {
                    IAdditionalActionPerformer performer = (IAdditionalActionPerformer)this.performers.get(i);
                    performer.setSelected(selected);
                    performer.performAction();
                }
            }
            this.adapter.informChanged(false);
        }
    }
}

