/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class SwarmAverageSpeed
extends CoreTableColumn
implements TableCellRefreshListener {
    public SwarmAverageSpeed(String sTableID) {
        super("swarm_average_speed", 2, -1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long speed = -1L;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            speed = dm.getStats().getTotalAveragePerPeer();
        }
        if (!cell.setSortValue(speed) && cell.isValid()) {
            return;
        }
        if (speed < 0L) {
            cell.setText("");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(speed));
        }
    }
}

