/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterSwitcher
implements TransportHelperFilter {
    private TransportHelperFilter current_reader;
    private TransportHelperFilter current_writer;
    private TransportHelperFilter second_filter;
    private int read_rem;
    private int write_rem;

    public TransportHelperFilterSwitcher(TransportHelperFilter _filter1, TransportHelperFilter _filter2, int _switch_read, int _switch_write) {
        this.read_rem = _switch_read;
        this.write_rem = _switch_write;
        this.current_reader = this.read_rem <= 0 ? _filter2 : _filter1;
        this.current_writer = this.write_rem <= 0 ? _filter2 : _filter1;
        this.second_filter = _filter2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        long total_written = 0L;
        if (this.current_writer != this.second_filter) {
            int[] limits = new int[buffers.length];
            int to_write = this.write_rem;
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer buffer = buffers[i];
                limits[i] = buffer.limit();
                int rem = buffer.remaining();
                if (rem > to_write) {
                    buffer.limit(buffer.position() + to_write);
                    to_write = 0;
                    continue;
                }
                to_write -= rem;
            }
            try {
                total_written = this.current_writer.write(buffers, array_offset, length);
                if (total_written <= 0L) {
                    long i = total_written;
                    return i;
                }
            }
            finally {
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.limit(limits[i]);
                }
            }
            this.write_rem = (int)((long)this.write_rem - total_written);
            if (this.write_rem == 0) {
                if (this.current_writer.hasBufferedWrite()) {
                    return total_written;
                }
                this.current_writer = this.second_filter;
            } else {
                return total_written;
            }
        }
        return total_written += this.current_writer.write(buffers, array_offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        long total_read = 0L;
        if (this.current_reader != this.second_filter) {
            int[] limits = new int[buffers.length];
            int to_read = this.read_rem;
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer buffer = buffers[i];
                limits[i] = buffer.limit();
                int rem = buffer.remaining();
                if (rem > to_read) {
                    buffer.limit(buffer.position() + to_read);
                    to_read = 0;
                    continue;
                }
                to_read -= rem;
            }
            try {
                total_read = this.current_reader.read(buffers, array_offset, length);
                if (total_read <= 0L) {
                    long i = total_read;
                    return i;
                }
            }
            finally {
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.limit(limits[i]);
                }
            }
            this.read_rem = (int)((long)this.read_rem - total_read);
            if (this.read_rem == 0) {
                this.current_reader = this.second_filter;
            } else {
                return total_read;
            }
        }
        return total_read += this.current_reader.read(buffers, array_offset, length);
    }

    public boolean hasBufferedWrite() {
        return this.current_writer.hasBufferedWrite();
    }

    public boolean hasBufferedRead() {
        return this.current_reader.hasBufferedRead();
    }

    public TransportHelper getHelper() {
        return this.second_filter.getHelper();
    }

    public String getName() {
        return this.second_filter.getName();
    }
}

