/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTHandshake
implements BTMessage,
RawMessage {
    public static final String PROTOCOL = "BitTorrent protocol";
    public static final byte[] BT_RESERVED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] AZ_RESERVED = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] reserved_bytes;
    private final byte[] datahash_bytes;
    private final byte[] peer_id_bytes;

    public BTHandshake(byte[] data_hash, byte[] peer_id, boolean set_reserve_bit) {
        this(set_reserve_bit ? AZ_RESERVED : BT_RESERVED, data_hash, peer_id);
    }

    private BTHandshake(byte[] reserved, byte[] data_hash, byte[] peer_id) {
        this.reserved_bytes = reserved;
        this.datahash_bytes = data_hash;
        this.peer_id_bytes = peer_id;
    }

    private void constructBuffer() {
        this.buffer = DirectByteBufferPool.getBuffer((byte)16, 68);
        this.buffer.put((byte)11, (byte)PROTOCOL.length());
        this.buffer.put((byte)11, PROTOCOL.getBytes());
        this.buffer.put((byte)11, this.reserved_bytes);
        this.buffer.put((byte)11, this.datahash_bytes);
        this.buffer.put((byte)11, this.peer_id_bytes);
        this.buffer.flip((byte)11);
    }

    public byte[] getReserved() {
        return this.reserved_bytes;
    }

    public byte[] getDataHash() {
        return this.datahash_bytes;
    }

    public byte[] getPeerId() {
        return this.peer_id_bytes;
    }

    public String getID() {
        return "BT_HANDSHAKE";
    }

    public byte[] getIDBytes() {
        return BTMessage.ID_BT_HANDSHAKE_BYTES;
    }

    public String getFeatureID() {
        return "BT1";
    }

    public int getFeatureSubID() {
        return 10;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_HANDSHAKE of dataID: " + ByteFormatter.nicePrint(this.datahash_bytes, true) + " peerID: " + PeerClassifier.getPrintablePeerID(this.peer_id_bytes);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 68) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 68");
        }
        if (data.get((byte)11) != (byte)PROTOCOL.length()) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.get() != (byte)PROTOCOL.length()");
        }
        byte[] header = new byte[PROTOCOL.getBytes().length];
        data.get((byte)11, header);
        if (!PROTOCOL.equals(new String(header))) {
            throw new MessageException("[" + this.getID() + "] decode error: invalid protocol given: " + new String(header));
        }
        byte[] reserved = new byte[8];
        data.get((byte)11, reserved);
        byte[] infohash = new byte[20];
        data.get((byte)11, infohash);
        byte[] peerid = new byte[20];
        data.get((byte)11, peerid);
        data.returnToPool();
        return new BTHandshake(reserved, infohash, peerid);
    }

    public DirectByteBuffer[] getRawData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public int getPriority() {
        return 2;
    }

    public boolean isNoDelay() {
        return true;
    }

    public Message[] messagesToRemove() {
        return null;
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public Message getBaseMessage() {
        return this;
    }
}

