/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.util;

import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;

public class PeerUtils {
    private static final String CONFIG_MAX_CONN_PER_TORRENT = "Max.Peer.Connections.Per.Torrent";
    public static final String CONFIG_MAX_CONN_TOTAL = "Max.Peer.Connections.Total";
    public static int MAX_CONNECTIONS_PER_TORRENT;
    public static int MAX_CONNECTIONS_TOTAL;
    public static int AUTO_MAX_CONNECTIONS_PER_TORRENT;
    public static int AUTO_MAX_CONNECTIONS_TOTAL;
    private static Set ignore_peer_ports;

    public static int numNewConnectionsAllowed(PeerIdentityDataID data_id, int specific_max) {
        int allowed;
        MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_TOTAL);
        MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_PER_TORRENT);
        int curConnPerTorrent = PeerIdentityManager.getIdentityCount(data_id);
        int curConnTotal = PeerIdentityManager.getTotalIdentityCount();
        int PER_TORRENT_LIMIT = specific_max;
        boolean autoMaxConnectionsEnabled = COConfigurationManager.getBooleanParameter("Enable.AutoMaxConnections", true);
        if (autoMaxConnectionsEnabled) {
            PER_TORRENT_LIMIT = 0;
            MAX_CONNECTIONS_TOTAL = AUTO_MAX_CONNECTIONS_TOTAL;
        }
        int perTorrentAllowed = -1;
        if (PER_TORRENT_LIMIT != 0) {
            int allowed2 = PER_TORRENT_LIMIT - curConnPerTorrent;
            if (allowed2 < 0) {
                allowed2 = 0;
            }
            perTorrentAllowed = allowed2;
        }
        int totalAllowed = -1;
        if (MAX_CONNECTIONS_TOTAL != 0) {
            allowed = MAX_CONNECTIONS_TOTAL - curConnTotal;
            if (allowed < 0) {
                allowed = 0;
            }
            totalAllowed = allowed;
        }
        allowed = -1;
        if (perTorrentAllowed > -1 && totalAllowed > -1) {
            allowed = Math.min(perTorrentAllowed, totalAllowed);
        } else if (perTorrentAllowed == -1 || totalAllowed == -1) {
            allowed = Math.max(perTorrentAllowed, totalAllowed);
        }
        return allowed;
    }

    private static void readIgnorePeerPorts() {
        String[] ports;
        String str = COConfigurationManager.getStringParameter("Ignore.peer.ports").trim();
        ignore_peer_ports.clear();
        if (str.length() > 0 && (ports = str.split("\\;")) != null && ports.length > 0) {
            for (int i = 0; i < ports.length; ++i) {
                String port = ports[i];
                int spreadPos = port.indexOf(45);
                if (spreadPos > 0 && spreadPos < port.length() - 1) {
                    try {
                        int iMin = Integer.parseInt(port.substring(0, spreadPos).trim());
                        int iMax = Integer.parseInt(port.substring(spreadPos + 1).trim());
                        for (int j = iMin; j <= iMax; ++j) {
                            ignore_peer_ports.add("" + j);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                ignore_peer_ports.add(port.trim());
            }
        }
    }

    public static boolean ignorePeerPort(int port) {
        return ignore_peer_ports.contains("" + port);
    }

    static {
        AUTO_MAX_CONNECTIONS_PER_TORRENT = 0;
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_PER_TORRENT, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_PER_TORRENT);
            }
        });
        MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_PER_TORRENT);
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_TOTAL, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_TOTAL);
            }
        });
        MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_TOTAL);
        COConfigurationManager.addAndFireParameterListener("Max Upload Speed KBs", new ParameterListener(){

            public void parameterChanged(String pname) {
                int calculatedMaxPeers = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
                calculatedMaxPeers *= 10;
                calculatedMaxPeers = Math.min(calculatedMaxPeers, 2000);
                AUTO_MAX_CONNECTIONS_TOTAL = calculatedMaxPeers = Math.max(100, calculatedMaxPeers);
            }
        });
        ignore_peer_ports = new HashSet();
        COConfigurationManager.addParameterListener("Ignore.peer.ports", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                PeerUtils.readIgnorePeerPorts();
            }
        });
        PeerUtils.readIgnorePeerPorts();
    }
}

