/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;

public class TRTrackerServerTorrentStatsImpl
implements TRTrackerServerTorrentStats {
    protected TRTrackerServerTorrentImpl torrent;
    protected long announce_count;
    protected long scrape_count;
    protected long completed_count;
    protected long uploaded;
    protected long downloaded;
    protected long left;
    protected long bytes_in;
    protected long bytes_out;

    protected TRTrackerServerTorrentStatsImpl(TRTrackerServerTorrentImpl _torrent) {
        this.torrent = _torrent;
    }

    protected void addAnnounce(long ul_diff, long dl_diff, long le_diff) {
        ++this.announce_count;
        this.uploaded += ul_diff < 0L ? 0L : ul_diff;
        this.downloaded += dl_diff < 0L ? 0L : dl_diff;
        this.left += le_diff;
        if (this.left < 0L) {
            this.left = 0L;
        }
    }

    protected void removeLeft(long _left) {
        this.left -= _left;
        if (this.left < 0L) {
            this.left = 0L;
        }
    }

    public long getAnnounceCount() {
        return this.announce_count;
    }

    protected void addScrape() {
        ++this.scrape_count;
    }

    public long getScrapeCount() {
        return this.scrape_count;
    }

    protected void addCompleted() {
        ++this.completed_count;
    }

    public long getCompletedCount() {
        return this.completed_count;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getAmountLeft() {
        return this.left;
    }

    protected void addXferStats(int in, int out) {
        this.bytes_in += (long)in;
        this.bytes_out += (long)out;
    }

    public long getBytesIn() {
        return this.bytes_in;
    }

    public long getBytesOut() {
        return this.bytes_out;
    }

    public int getSeedCount() {
        return this.torrent.getSeedCount();
    }

    public int getLeecherCount() {
        return this.torrent.getLeecherCount();
    }

    public int getBadNATPeerCount() {
        return this.torrent.getBadNATPeerCount();
    }

    public String getString() {
        return "an=" + this.announce_count + ",sc=" + this.scrape_count + ",co=" + this.completed_count + ",le=" + this.getLeecherCount() + ",se=" + this.getSeedCount() + ",bi=" + this.bytes_in + ",bo=" + this.bytes_out;
    }
}

