/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.LocaleDecoder;
import org.gudy.azureus2.plugins.utils.LocaleListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleDecoderImpl;

public class LocaleUtilitiesImpl
implements LocaleUtilities {
    private PluginInterface pi;
    private List listeners;

    public LocaleUtilitiesImpl(PluginInterface _pi) {
        this.pi = _pi;
    }

    public void integrateLocalisedMessageBundle(String resource_bundle_prefix) {
        MessageText.integratePluginMessages(resource_bundle_prefix, this.pi.getPluginClassLoader());
    }

    public String getLocalisedMessageText(String key) {
        return MessageText.getString(key);
    }

    public String getLocalisedMessageText(String key, String[] params) {
        return MessageText.getString(key, params);
    }

    public LocaleDecoder[] getDecoders() {
        LocaleUtilDecoder[] decs = LocaleUtil.getSingleton().getDecoders();
        LocaleDecoder[] res = new LocaleDecoder[decs.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new LocaleDecoderImpl(decs[i]);
        }
        return res;
    }

    public void addListener(LocaleListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            COConfigurationManager.addParameterListener("locale.set.complete.count", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    for (int i = 0; i < LocaleUtilitiesImpl.this.listeners.size(); ++i) {
                        try {
                            ((LocaleListener)LocaleUtilitiesImpl.this.listeners.get(i)).localeChanged(MessageText.getCurrentLocale());
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
        }
        this.listeners.add(l);
    }

    public void removeListener(LocaleListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }
}

