/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationListener;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class ProgressWindow {
    private volatile Shell shell;
    private volatile boolean task_complete;

    public static void register(AzureusCore core) {
        core.addOperationListener(new AzureusCoreOperationListener(){

            public boolean operationCreated(AzureusCoreOperation operation) {
                if (operation.getOperationType() == 2 && Utils.isThisThreadSWT() && operation.getTask() != null) {
                    new ProgressWindow(operation);
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressWindow(final AzureusCoreOperation operation) {
        Object display;
        final RuntimeException[] error = new RuntimeException[]{null};
        new DelayedEvent("ProgWin", 1000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (!ProgressWindow.this.task_complete) {
                        Utils.execSWTThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    if (!ProgressWindow.this.task_complete) {
                                        ProgressWindow.this.showDialog();
                                    }
                                }
                            }
                        }, false);
                    }
                }
            }
        });
        new AEThread("ProgressWindow", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void runSupport() {
                3 var1_1;
                try {
                    operation.getTask().run(operation);
                    var1_1 = this;
                }
                catch (RuntimeException e2222222222) {
                    error[0] = e2222222222;
                    3 e2222222222 = this;
                    synchronized (e2222222222) {
                        ProgressWindow.this.task_complete = true;
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                            }
                        }, true);
                    }
                }
                catch (Throwable e) {
                    error[0] = new RuntimeException(e);
                    3 var1_5 = this;
                    {
                        catch (Throwable throwable) {
                            3 var6_10 = this;
                            synchronized (var6_10) {
                                ProgressWindow.this.task_complete = true;
                                Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */, true);
                            }
                            throw throwable;
                        }
                    }
                    synchronized (var1_5) {
                        ProgressWindow.this.task_complete = true;
                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */, true);
                    }
                }
                synchronized (var1_1) {
                    ProgressWindow.this.task_complete = true;
                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */, true);
                }
            }
        }.start();
        try {
            display = SWTThread.getInstance().getDisplay();
            while (!this.task_complete && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display = this;
            synchronized (display) {
                this.task_complete = true;
            }
            try {
                if (this.shell != null && !this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    protected void showDialog() {
        this.shell = ShellFactory.createMainShell(67680);
        this.shell.setText(MessageText.getString("progress.window.title"));
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = false;
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        InputStream is = ImageRepository.getImageAsStream("working");
        if (is == null) {
            new Label((Composite)this.shell, 0);
        } else {
            final ImageLoader loader = new ImageLoader();
            final Color background = this.shell.getBackground();
            loader.load(is);
            Canvas canvas = new Canvas((Composite)this.shell, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(loader.logicalScreenWidth, loader.logicalScreenWidth);
                }
            };
            final GC canvas_gc = new GC((Drawable)canvas);
            new AEThread("GifAnim", true){
                private Image image;
                private boolean useGIFBackground;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    Display display = ProgressWindow.this.shell.getDisplay();
                    ImageData[] image_data = loader.data;
                    Image offScreenImage = new Image((Device)display, loader.logicalScreenWidth, loader.logicalScreenHeight);
                    GC offScreenImageGC = new GC((Drawable)offScreenImage);
                    offScreenImageGC.setBackground(background);
                    offScreenImageGC.fillRectangle(0, 0, loader.logicalScreenWidth, loader.logicalScreenHeight);
                    try {
                        int imageDataIndex = 0;
                        ImageData imageData = image_data[imageDataIndex];
                        if (this.image != null && !this.image.isDisposed()) {
                            this.image.dispose();
                        }
                        this.image = new Image((Device)display, imageData);
                        offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        int repeatCount = loader.repeatCount;
                        while (!ProgressWindow.this.task_complete && loader.repeatCount == 0 || repeatCount > 0) {
                            switch (imageData.disposalMethod) {
                                case 2: {
                                    Color bgColor = null;
                                    if (this.useGIFBackground && loader.backgroundPixel != -1) {
                                        bgColor = new Color((Device)display, imageData.palette.getRGB(loader.backgroundPixel));
                                    }
                                    offScreenImageGC.setBackground(bgColor != null ? bgColor : background);
                                    offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                                    if (bgColor == null) break;
                                    bgColor.dispose();
                                    break;
                                }
                                case 3: {
                                    offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                }
                            }
                            imageDataIndex = (imageDataIndex + 1) % image_data.length;
                            imageData = image_data[imageDataIndex];
                            this.image.dispose();
                            this.image = new Image((Device)display, imageData);
                            offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                            canvas_gc.drawImage(offScreenImage, 0, 0);
                            try {
                                int ms = imageData.delayTime * 10;
                                if (ms < 20) {
                                    ms += 30;
                                }
                                if (ms < 30) {
                                    ms += 10;
                                }
                                Thread.sleep(ms);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (imageDataIndex != image_data.length - 1) continue;
                            --repeatCount;
                        }
                    }
                    catch (SWTException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (offScreenImage != null && !offScreenImage.isDisposed()) {
                            offScreenImage.dispose();
                        }
                        if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                            offScreenImageGC.dispose();
                        }
                        if (this.image != null && !this.image.isDisposed()) {
                            this.image.dispose();
                        }
                    }
                }
            }.start();
        }
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("progress.window.msg.filemove"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }
}

