/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionAdvanced
implements UISWTConfigSection {
    private final String CFG_PREFIX = "ConfigView.section.connection.advanced.";
    private final int REQUIRED_MODE = 2;

    public String configSectionGetParentSection() {
        return "server";
    }

    public String configSectionGetName() {
        return "connection.advanced";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout advanced_layout = new GridLayout();
        cSection.setLayout((Layout)advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        LinkLabel linkLabel = new LinkLabel(cSection, gridData, "ConfigView.section.connection.advanced.info.link", MessageText.getString("ConfigView.section.connection.advanced.url"));
        Group gSocket = new Group(cSection, 0);
        Messages.setLanguageText((Widget)gSocket, "ConfigView.section.connection.advanced.socket.group");
        gridData = new GridData(272);
        gSocket.setLayoutData((Object)gridData);
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 3;
        gSocket.setLayout((Layout)glayout);
        Label lmaxout = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lmaxout, "ConfigView.section.connection.network.max.simultaneous.connect.attempts");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        lmaxout.setLayoutData((Object)gridData);
        IntParameter max_connects = new IntParameter((Composite)gSocket, "network.max.simultaneous.connect.attempts", 1, 100, false, false);
        gridData = new GridData();
        gridData.widthHint = 30;
        max_connects.setLayoutData(gridData);
        Label lbind = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lbind, "ConfigView.label.bindip");
        StringParameter bindip = new StringParameter((Composite)gSocket, "Bind IP", "");
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.horizontalSpan = 2;
        bindip.setLayoutData(gridData);
        Label lpbind = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lpbind, "ConfigView.section.connection.advanced.bind_port");
        IntParameter port_bind = new IntParameter((Composite)gSocket, "network.bind.local.port", 0, 65535, true, false);
        gridData = new GridData();
        gridData.widthHint = 40;
        gridData.horizontalSpan = 2;
        port_bind.setLayoutData(gridData);
        Label lmtu = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lmtu, "ConfigView.section.connection.advanced.mtu");
        IntParameter mtu_size = new IntParameter((Composite)gSocket, "network.tcp.mtu.size");
        mtu_size.setMaximumValue(524288);
        gridData = new GridData();
        gridData.widthHint = 40;
        gridData.horizontalSpan = 2;
        mtu_size.setLayoutData(gridData);
        Label lsend = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lsend, "ConfigView.section.connection.advanced.SO_SNDBUF");
        IntParameter SO_SNDBUF = new IntParameter((Composite)gSocket, "network.tcp.socket.SO_SNDBUF");
        gridData = new GridData();
        gridData.widthHint = 40;
        gridData.horizontalSpan = 2;
        SO_SNDBUF.setLayoutData(gridData);
        Label lreceiv = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lreceiv, "ConfigView.section.connection.advanced.SO_RCVBUF");
        IntParameter SO_RCVBUF = new IntParameter((Composite)gSocket, "network.tcp.socket.SO_RCVBUF");
        gridData = new GridData();
        gridData.widthHint = 40;
        gridData.horizontalSpan = 2;
        SO_RCVBUF.setLayoutData(gridData);
        Label ltos = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)ltos, "ConfigView.section.connection.advanced.IPTOS");
        final StringParameter IPTOS = new StringParameter((Composite)gSocket, "network.tcp.socket.IPTOS");
        gridData = new GridData();
        gridData.widthHint = 30;
        gridData.horizontalSpan = 2;
        IPTOS.setLayoutData(gridData);
        IPTOS.addChangeListener(new ParameterChangeListener(){
            final Color obg;
            final Color ofg;
            {
                this.obg = IPTOS.getControl().getBackground();
                this.ofg = IPTOS.getControl().getForeground();
            }

            public void parameterChanged(Parameter p, boolean caused_internally) {
                String raw = IPTOS.getValue();
                int value = -1;
                try {
                    value = Integer.decode(raw);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (value < 0 || value > 255) {
                    ConfigurationManager.getInstance().removeParameter("network.tcp.socket.IPTOS");
                    if (raw != null && raw.length() > 0) {
                        IPTOS.getControl().setBackground(Colors.red);
                        IPTOS.getControl().setForeground(Colors.white);
                    } else {
                        IPTOS.getControl().setBackground(this.obg);
                        IPTOS.getControl().setForeground(this.ofg);
                    }
                    ConfigSectionConnectionAdvanced.this.enableTOSRegistrySetting(false);
                } else {
                    IPTOS.getControl().setBackground(this.obg);
                    IPTOS.getControl().setForeground(this.ofg);
                    ConfigSectionConnectionAdvanced.this.enableTOSRegistrySetting(true);
                }
            }
        });
        return cSection;
    }

    private void enableTOSRegistrySetting(boolean enable) {
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.SetTCPTOSEnabled)) {
            try {
                mgr.setTCPTOSEnabled(enable);
            }
            catch (PlatformManagerException pe) {
                Debug.printStackTrace(pe);
            }
        }
    }
}

