/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;

class StyledTextDragAndDropEffect
extends DragAndDropEffect {
    StyledText text;
    long scrollBeginTime;
    int scrollX = -1;
    int scrollY = -1;
    static final int SCROLL_HYSTERESIS = 100;
    static final int SCROLL_TOLERANCE = 20;

    StyledTextDragAndDropEffect(StyledText control) {
        this.text = control;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        Point pt = this.text.getDisplay().map(null, this.text, x, y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.text.getCharCount() == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.scrollX != -1 && this.scrollY != -1 && this.scrollBeginTime != 0L && (pt.x >= this.scrollX && pt.x <= this.scrollX + 20 || pt.y >= this.scrollY && pt.y <= this.scrollY + 20)) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int topPixel;
                int lineHeight;
                int leftPixel;
                Rectangle area = this.text.getClientArea();
                Rectangle bounds = this.text.getTextBounds(0, 0);
                int charWidth = bounds.width;
                if (pt.x < area.x + 2 * charWidth) {
                    leftPixel = this.text.getHorizontalPixel();
                    this.text.setHorizontalPixel(leftPixel - charWidth);
                    if (this.text.getHorizontalPixel() != leftPixel) {
                        this.text.redraw();
                    }
                }
                if (pt.x > area.width - 2 * charWidth) {
                    leftPixel = this.text.getHorizontalPixel();
                    this.text.setHorizontalPixel(leftPixel + charWidth);
                    if (this.text.getHorizontalPixel() != leftPixel) {
                        this.text.redraw();
                    }
                }
                if (pt.y < area.y + (lineHeight = bounds.height)) {
                    topPixel = this.text.getTopPixel();
                    this.text.setTopPixel(topPixel - lineHeight);
                    if (this.text.getTopPixel() != topPixel) {
                        this.text.redraw();
                    }
                }
                if (pt.y > area.height - lineHeight) {
                    topPixel = this.text.getTopPixel();
                    this.text.setTopPixel(topPixel + lineHeight);
                    if (this.text.getTopPixel() != topPixel) {
                        this.text.redraw();
                    }
                }
                this.scrollBeginTime = 0L;
                this.scrollY = -1;
                this.scrollX = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 100L;
            this.scrollX = pt.x;
            this.scrollY = pt.y;
        }
        if ((effect & 1) != 0) {
            StyledTextContent content = this.text.getContent();
            int oldOffset = this.text.getCaretOffset();
            int newOffset = -1;
            try {
                newOffset = this.text.getOffsetAtLocation(pt);
            }
            catch (IllegalArgumentException ex1) {
                int maxOffset = content.getCharCount();
                Point maxLocation = this.text.getLocationAtOffset(maxOffset);
                if (pt.y >= maxLocation.y) {
                    try {
                        newOffset = this.text.getOffsetAtLocation(new Point(pt.x, maxLocation.y));
                    }
                    catch (IllegalArgumentException ex2) {
                        newOffset = maxOffset;
                    }
                }
                try {
                    int startOffset = this.text.getOffsetAtLocation(new Point(0, pt.y));
                    int endOffset = maxOffset;
                    int line = content.getLineAtOffset(startOffset);
                    int lineCount = content.getLineCount();
                    if (line + 1 < lineCount) {
                        endOffset = content.getOffsetAtLine(line + 1) - 1;
                    }
                    int lineHeight = this.text.getLineHeight(startOffset);
                    int i = endOffset;
                    while (i >= startOffset) {
                        Point p = this.text.getLocationAtOffset(i);
                        if (p.x < pt.x && p.y < pt.y && p.y + lineHeight > pt.y) {
                            newOffset = i;
                        }
                        --i;
                    }
                }
                catch (IllegalArgumentException ex2) {
                    newOffset = -1;
                }
            }
            if (newOffset != -1 && newOffset != oldOffset) {
                int line = content.getLineAtOffset(newOffset);
                int lineOffset = content.getOffsetAtLine(line);
                int offsetInLine = newOffset - lineOffset;
                if (offsetInLine > content.getLine(line).length()) {
                    newOffset = Math.max(0, newOffset - 1);
                }
                this.text.setFocus();
                OS.ImageList_DragShowNolock(false);
                this.text.setCaretOffset(newOffset);
                OS.ImageList_DragShowNolock(true);
            }
        }
    }
}

