/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    long labelHandle;
    long imageHandle;
    long buttonHandle;
    Table parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    boolean useFixedWidth;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.setOrientation();
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_resizable(this.handle);
    }

    public int getWidth() {
        this.checkWidget();
        if (!OS.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        if (this.useFixedWidth) {
            return OS.gtk_tree_view_column_get_fixed_width(this.handle);
        }
        return OS.gtk_tree_view_column_get_width(this.handle);
    }

    long gtk_clicked(long widget) {
        boolean doubleClick = false;
        long eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0L) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventButton.sizeof);
            switch (gdkEvent.type) {
                case 7: {
                    int clickTime = this.display.getDoubleClickTime();
                    int eventTime = gdkEvent.time;
                    int eventButton = gdkEvent.button;
                    if (this.lastButton == eventButton && this.lastTime != 0 && Math.abs(this.lastTime - eventTime) <= clickTime) {
                        doubleClick = true;
                    }
                    this.lastTime = eventTime == 0 ? 1 : eventTime;
                    this.lastButton = eventButton;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        this.postEvent(doubleClick ? 14 : 13);
        return 0L;
    }

    long gtk_mnemonic_activate(long widget, long arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    long gtk_size_allocate(long widget, long allocation) {
        this.useFixedWidth = false;
        int x = OS.GTK_WIDGET_X(widget);
        int width = OS.GTK_WIDGET_WIDTH(widget);
        if (x != this.lastX) {
            this.lastX = x;
            this.sendEvent(10);
        }
        if (width != this.lastWidth) {
            this.lastWidth = width;
            this.sendEvent(11);
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect(this.handle, OS.clicked, this.display.windowProc2, 5L);
        if (this.buttonHandle != 0L) {
            OS.g_signal_connect(this.buttonHandle, OS.size_allocate, this.display.windowProc3, 40L);
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect(this.labelHandle, OS.mnemonic_activate, this.display.windowProc3, 27L);
        }
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        if (this.buttonHandle != 0L) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request(this.buttonHandle, requisition);
            width = requisition.width;
        }
        if ((this.parent.style & 0x10000000) == 0) {
            long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter_first(this.parent.modelHandle, iter)) {
                do {
                    width = Math.max(width, this.parent.calculateWidth(this.handle, iter));
                } while (OS.gtk_tree_model_iter_next(this.parent.modelHandle, iter));
            }
            OS.g_free(iter);
        }
        this.setWidth(width);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, index == 0, this.style);
    }

    void setFontDescription(long font) {
        OS.gtk_widget_modify_font(this.labelHandle, font);
        OS.gtk_widget_modify_font(this.imageHandle, font);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            long pixbuf = imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_resizable(this.handle, resizable);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_reorderable(this.handle, moveable);
    }

    void setOrientation() {
        if ((this.parent.style & 0x4000000) != 0 && this.buttonHandle != 0L) {
            OS.gtk_widget_set_direction(this.buttonHandle, 2);
            OS.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width > 0) {
            this.useFixedWidth = true;
            OS.gtk_widget_realize(this.parent.handle);
            OS.gtk_tree_view_column_set_fixed_width(this.handle, width);
            OS.gtk_tree_view_column_set_visible(this.handle, true);
        } else {
            OS.gtk_tree_view_column_set_visible(this.handle, false);
        }
    }
}

