/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.control;

import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public interface DHTControl {
    public static final int K_DEFAULT = 20;
    public static final int B_DEFAULT = 4;
    public static final int MAX_REP_PER_NODE_DEFAULT = 5;
    public static final int SEARCH_CONCURRENCY_DEFAULT = 5;
    public static final int LOOKUP_CONCURRENCY_DEFAULT = 10;
    public static final int CACHE_AT_CLOSEST_N_DEFAULT = 1;
    public static final int ORIGINAL_REPUBLISH_INTERVAL_DEFAULT = 28800000;
    public static final int CACHE_REPUBLISH_INTERVAL_DEFAULT = 1800000;

    public void seed(boolean var1);

    public void put(byte[] var1, String var2, byte[] var3, byte var4, DHTOperationListener var5);

    public DHTTransportValue getLocalValue(byte[] var1);

    public void get(byte[] var1, String var2, byte var3, int var4, long var5, boolean var7, DHTOperationListener var8);

    public byte[] remove(byte[] var1, String var2, DHTOperationListener var3);

    public DHTControlStats getStats();

    public DHTTransport getTransport();

    public DHTRouter getRouter();

    public DHTDB getDataBase();

    public DHTControlActivity[] getActivities();

    public void exportState(DataOutputStream var1, int var2) throws IOException;

    public void importState(DataInputStream var1) throws IOException;

    public List getClosestKContactsList(byte[] var1, boolean var2);

    public List sortContactsByDistance(List var1);

    public void putEncodedKey(byte[] var1, String var2, DHTTransportValue var3, long var4, boolean var6);

    public void putDirectEncodedKeys(byte[][] var1, String var2, DHTTransportValue[][] var3, List var4);

    public int computeAndCompareDistances(byte[] var1, byte[] var2, byte[] var3);

    public boolean verifyContact(DHTTransportContact var1, boolean var2);

    public List getContacts();

    public void addListener(DHTControlListener var1);

    public void removeListener(DHTControlListener var1);

    public void print();
}

