/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.nat.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTNATPuncherImpl
implements DHTNATPuncher {
    private static boolean TESTING = false;
    private static boolean TRACE = false;
    private static final int RT_BIND_REQUEST = 0;
    private static final int RT_BIND_REPLY = 1;
    private static final int RT_PUNCH_REQUEST = 2;
    private static final int RT_PUNCH_REPLY = 3;
    private static final int RT_CONNECT_REQUEST = 4;
    private static final int RT_CONNECT_REPLY = 5;
    private static final int RESP_OK = 0;
    private static final int RESP_NOT_OK = 1;
    private static final int RESP_FAILED = 2;
    private static byte[] transfer_handler_key;
    private boolean started;
    private DHT dht;
    private DHTLogger logger;
    private PluginInterface plugin_interface;
    private Formatters formatters;
    private UTTimer timer;
    private static final long REPUBLISH_TIME_MIN = 300000L;
    private static final long TRANSFER_TIMEOUT = 30000L;
    private static final long RENDEZVOUS_LOOKUP_TIMEOUT = 30000L;
    private static final int RENDEZVOUS_SERVER_MAX = 8;
    private static final long RENDEZVOUS_SERVER_TIMEOUT = 300000L;
    private static final int RENDEZVOUS_CLIENT_PING_PERIOD = 50000;
    private static final int RENDEZVOUS_PING_FAIL_LIMIT = 4;
    private Monitor server_mon;
    private Map rendezvous_bindings = new HashMap();
    private long last_publish;
    private Monitor pub_mon;
    private boolean publish_in_progress;
    private volatile DHTTransportContact rendezvous_local_contact;
    private volatile DHTTransportContact rendezvous_target;
    private volatile DHTTransportContact last_ok_rendezvous;
    private static final int FAILED_RENDEZVOUS_HISTORY_MAX = 16;
    private Map failed_rendezvous = new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 16;
        }
    };
    private boolean rendezvous_thread_running;
    private Map explicit_rendezvous_map = new HashMap();

    public DHTNATPuncherImpl(DHT _dht) {
        this.dht = _dht;
        this.logger = this.dht.getLogger();
        this.plugin_interface = this.dht.getLogger().getPluginInterface();
        this.formatters = this.plugin_interface.getUtilities().getFormatters();
        this.pub_mon = this.plugin_interface.getUtilities().getMonitor();
        this.server_mon = this.plugin_interface.getUtilities().getMonitor();
        this.timer = this.plugin_interface.getUtilities().createTimer("DHTNATPuncher:refresher", true);
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        DHTTransport transport = this.dht.getTransport();
        transport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact local_contact) {
                DHTNATPuncherImpl.this.publish(false);
            }

            public void currentAddress(String address) {
            }

            public void reachabilityChanged(boolean reacheable) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        transport.registerTransferHandler(transfer_handler_key, new DHTTransportTransferHandler(){

            public byte[] handleRead(DHTTransportContact originator, byte[] key) {
                return null;
            }

            public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
                return DHTNATPuncherImpl.this.receiveRequest(originator, value);
            }
        });
        this.timer.addPeriodicEvent(300000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        this.timer.addPeriodicEvent(150000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent event) {
                long now = DHTNATPuncherImpl.this.plugin_interface.getUtilities().getCurrentSystemTime();
                try {
                    DHTNATPuncherImpl.this.server_mon.enter();
                    Iterator it = DHTNATPuncherImpl.this.rendezvous_bindings.values().iterator();
                    while (it.hasNext()) {
                        Object[] entry2 = (Object[])it.next();
                        long time = (Long)entry2[1];
                        boolean removed = false;
                        if (time > now) {
                            it.remove();
                            removed = true;
                        } else if (now - time > 300000L) {
                            it.remove();
                            removed = true;
                        }
                        if (!removed) continue;
                        DHTNATPuncherImpl.this.log("Rendezvous " + ((DHTTransportContact)entry2[0]).getString() + " removed due to inactivity");
                    }
                }
                finally {
                    DHTNATPuncherImpl.this.server_mon.exit();
                }
            }
        });
        this.publish(false);
    }

    public boolean active() {
        return this.rendezvous_local_contact != null;
    }

    public boolean operational() {
        DHTTransportContact ok = this.last_ok_rendezvous;
        return ok != null && ok == this.rendezvous_target;
    }

    protected void publish(boolean force) {
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (now < this.last_publish && !force) {
            this.last_publish = now;
        } else if (force || now - this.last_publish >= 300000L) {
            this.last_publish = now;
            this.plugin_interface.getUtilities().createThread("DHTNATPuncher:publisher", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        if (DHTNATPuncherImpl.this.publish_in_progress) {
                            return;
                        }
                        DHTNATPuncherImpl.this.publish_in_progress = true;
                    }
                    finally {
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                    try {
                        DHTNATPuncherImpl.this.publishSupport();
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            DHTNATPuncherImpl.this.publish_in_progress = false;
                        }
                        finally {
                            DHTNATPuncherImpl.this.pub_mon.exit();
                        }
                        throw throwable;
                    }
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        DHTNATPuncherImpl.this.publish_in_progress = false;
                    }
                    finally {
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSupport() {
        DHTTransport transport = this.dht.getTransport();
        if (TESTING || !transport.isReachable()) {
            int i;
            boolean force;
            DHTTransportContact local_contact = transport.getLocalContact();
            boolean bl = force = this.rendezvous_target != null && this.failed_rendezvous.containsKey(this.rendezvous_target.getAddress());
            if (this.rendezvous_local_contact != null && !force && local_contact.getAddress().equals(this.rendezvous_local_contact.getAddress())) {
                return;
            }
            DHTTransportContact explicit = (DHTTransportContact)this.explicit_rendezvous_map.get(local_contact.getAddress());
            if (explicit != null) {
                try {
                    this.pub_mon.enter();
                    this.rendezvous_local_contact = local_contact;
                    this.rendezvous_target = explicit;
                    this.runRendezvous();
                }
                finally {
                    this.pub_mon.exit();
                }
            }
            final DHTTransportContact[] new_rendezvous_target = new DHTTransportContact[]{null};
            DHTTransportContact[] reachables = this.dht.getTransport().getReachableContacts();
            int reachables_tried = 0;
            int reachables_skipped = 0;
            final Semaphore sem = this.plugin_interface.getUtilities().getSemaphore();
            for (i = 0; i < reachables.length; ++i) {
                DHTTransportContact contact = reachables[i];
                try {
                    this.pub_mon.enter();
                    if (new_rendezvous_target[0] != null) break;
                    if (this.failed_rendezvous.containsKey(contact.getAddress())) {
                        ++reachables_skipped;
                        sem.release();
                        continue;
                    }
                }
                finally {
                    this.pub_mon.exit();
                }
                if (i > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                ++reachables_tried;
                contact.sendPing(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pingReply(DHTTransportContact ok_contact) {
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            if (new_rendezvous_target[0] == null) {
                                new_rendezvous_target[0] = ok_contact;
                            }
                        }
                        finally {
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            sem.release();
                        }
                    }

                    public void failed(DHTTransportContact failed_contact, Throwable e) {
                        sem.release();
                    }
                });
            }
            for (i = 0; i < reachables.length; ++i) {
                sem.reserve();
                try {
                    this.pub_mon.enter();
                    if (new_rendezvous_target[0] == null) continue;
                    this.rendezvous_target = new_rendezvous_target[0];
                    this.rendezvous_local_contact = local_contact;
                    this.log("Rendezvous found: " + this.rendezvous_local_contact.getString() + " -> " + this.rendezvous_target.getString());
                    this.runRendezvous();
                    break;
                }
                finally {
                    this.pub_mon.exit();
                }
            }
            if (new_rendezvous_target[0] == null) {
                this.log("No rendezvous found: candidates=" + reachables.length + ",tried=" + reachables_tried + ",skipped=" + reachables_skipped);
                try {
                    this.pub_mon.enter();
                    this.rendezvous_local_contact = null;
                    this.rendezvous_target = null;
                }
                finally {
                    this.pub_mon.exit();
                }
            }
        } else {
            try {
                this.pub_mon.enter();
                this.rendezvous_local_contact = null;
                this.rendezvous_target = null;
            }
            finally {
                this.pub_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRendezvous() {
        try {
            this.pub_mon.enter();
            if (!this.rendezvous_thread_running) {
                this.rendezvous_thread_running = true;
                this.plugin_interface.getUtilities().createThread("DHTNatPuncher:rendevzous", new Runnable(){

                    public void run() {
                        DHTNATPuncherImpl.this.runRendezvousSupport();
                    }
                });
            }
        }
        finally {
            this.pub_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRendezvousSupport() {
        DHTTransportContact current_local = null;
        DHTTransportContact current_target = null;
        int rendevzous_fail_count = 0;
        while (true) {
            try {
                DHTTransportContact latest_target;
                DHTTransportContact latest_local;
                try {
                    this.pub_mon.enter();
                    latest_local = this.rendezvous_local_contact;
                    latest_target = this.rendezvous_target;
                }
                finally {
                    this.pub_mon.exit();
                }
                if (current_local != null || latest_local != null) {
                    if (current_local != latest_local) {
                        if (current_local != null) {
                            this.log("Removing publish for " + current_local.getString() + " -> " + current_target.getString());
                            this.dht.remove(this.getPublishKey(current_local), "DHTNatPuncher: removal of publish", new DHTOperationListener(){

                                public void searching(DHTTransportContact contact, int level, int active_searches) {
                                }

                                public void found(DHTTransportContact contact) {
                                }

                                public void read(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                public void complete(boolean timeout) {
                                }
                            });
                        }
                        if (latest_local != null) {
                            this.log("Adding publish for " + latest_local.getString() + " -> " + latest_target.getString());
                            rendevzous_fail_count = 2;
                            this.dht.put(this.getPublishKey(latest_local), "DHTNatPuncher: publish", this.encodePublishValue(latest_target), (byte)0, new DHTOperationListener(){

                                public void searching(DHTTransportContact contact, int level, int active_searches) {
                                }

                                public void found(DHTTransportContact contact) {
                                }

                                public void read(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                public void complete(boolean timeout) {
                                }
                            });
                        }
                    } else if (current_target != latest_target) {
                        this.log("Updating publish for " + latest_local.getString() + " -> " + latest_target.getString());
                        rendevzous_fail_count = 2;
                        this.dht.put(this.getPublishKey(latest_local), "DHTNatPuncher: update publish", this.encodePublishValue(latest_target), (byte)0, new DHTOperationListener(){

                            public void searching(DHTTransportContact contact, int level, int active_searches) {
                            }

                            public void found(DHTTransportContact contact) {
                            }

                            public void read(DHTTransportContact contact, DHTTransportValue value) {
                            }

                            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                            }

                            public void complete(boolean timeout) {
                            }
                        });
                    }
                }
                current_local = latest_local;
                current_target = latest_target;
                if (current_target == null) continue;
                int bind_result = this.sendBind(current_target);
                if (bind_result == 0) {
                    if (TRACE) {
                        System.out.println("Rendezvous:" + current_target.getString() + " OK");
                    }
                    rendevzous_fail_count = 0;
                    if (this.last_ok_rendezvous == current_target) continue;
                    this.last_ok_rendezvous = current_target;
                    this.log("Rendezvous " + latest_target.getString() + " operational");
                    continue;
                }
                rendevzous_fail_count = bind_result == 1 ? 4 : ++rendevzous_fail_count;
                if (rendevzous_fail_count != 4) continue;
                this.log("Rendezvous failed: " + current_target.getString());
                if (TRACE) {
                    this.log("Rendezvous:" + current_target.getString() + " Failed");
                }
                try {
                    this.pub_mon.enter();
                    this.failed_rendezvous.put(current_target.getAddress(), "");
                }
                finally {
                    this.pub_mon.exit();
                }
                this.publish(true);
                continue;
            }
            catch (Throwable e) {
                this.log(e);
                continue;
            }
            finally {
                try {
                    Thread.sleep(50000L);
                }
                catch (Throwable e) {
                    this.log(e);
                    break;
                }
                continue;
            }
            break;
        }
    }

    protected byte[] sendRequest(DHTTransportContact target, byte[] data) {
        try {
            return this.dht.getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, target, transfer_handler_key, data, 30000L);
        }
        catch (DHTTransportException e) {
            return null;
        }
    }

    protected byte[] receiveRequest(DHTTransportContact originator, byte[] data) {
        try {
            Map res = this.receiveRequest(originator, this.formatters.bDecode(data));
            if (res == null) {
                return null;
            }
            return this.formatters.bEncode(res);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected Map sendRequest(DHTTransportContact target, Map data) {
        try {
            byte[] res = this.sendRequest(target, this.formatters.bEncode(data));
            if (res == null) {
                return null;
            }
            return this.formatters.bDecode(res);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected Map receiveRequest(DHTTransportContact originator, Map data) {
        int type = ((Long)data.get("type")).intValue();
        HashMap<String, Long> response = new HashMap<String, Long>();
        switch (type) {
            case 0: {
                response.put("type", new Long(1L));
                this.receiveBind(originator, data, response);
                break;
            }
            case 2: {
                response.put("type", new Long(3L));
                this.receivePunch(originator, data, response);
                break;
            }
            case 4: {
                response.put("type", new Long(5L));
                this.receiveConnect(originator, data, response);
                break;
            }
            default: {
                response = null;
            }
        }
        return response;
    }

    protected int sendBind(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(0L));
            Map response = this.sendRequest(target, request2);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 1) {
                int result = ((Long)response.get("ok")).intValue();
                if (TRACE) {
                    System.out.println("received bind reply: " + (result == 0 ? "failed" : "ok"));
                }
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveBind(DHTTransportContact originator, Map request2, Map response) {
        if (TRACE) {
            System.out.println("received bind request");
        }
        boolean ok = true;
        boolean log = true;
        try {
            this.server_mon.enter();
            Object[] entry2 = (Object[])this.rendezvous_bindings.get(originator.getAddress().toString());
            if (entry2 == null) {
                if (this.rendezvous_bindings.size() == 8) {
                    ok = false;
                }
            } else {
                log = false;
            }
            if (ok) {
                long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
                this.rendezvous_bindings.put(originator.getAddress().toString(), new Object[]{originator, new Long(now)});
            }
        }
        finally {
            this.server_mon.exit();
        }
        if (log) {
            this.log("Rendezvous request from " + originator.getString() + " " + (ok ? "accepted" : "denied"));
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    protected int sendPunch(DHTTransportContact rendezvous, DHTTransportContact target) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(2L));
            request2.put("target", target.getAddress().toString().getBytes());
            Map response = this.sendRequest(rendezvous, request2);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 3) {
                int result = ((Long)response.get("ok")).intValue();
                if (TRACE) {
                    System.out.println("received punch reply: " + (result == 0 ? "failed" : "ok"));
                }
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePunch(DHTTransportContact originator, Map request2, Map response) {
        if (TRACE) {
            System.out.println("received puch request");
        }
        boolean ok = false;
        try {
            DHTTransportContact target;
            this.server_mon.enter();
            String target_str = new String((byte[])request2.get("target"));
            Object[] entry2 = (Object[])this.rendezvous_bindings.get(target_str);
            if (entry2 != null && this.sendConnect(target = (DHTTransportContact)entry2[0], originator) == 0) {
                ok = true;
            }
            this.log("Rendezvous punch request from " + originator.getString() + " to " + target_str + " " + (ok ? "initiated" : "failed"));
        }
        finally {
            this.server_mon.exit();
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    protected int sendConnect(DHTTransportContact target, DHTTransportContact originator) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(4L));
            request2.put("origin", this.encodeContact(originator));
            Map response = this.sendRequest(target, request2);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 5) {
                int result = ((Long)response.get("ok")).intValue();
                if (TRACE) {
                    System.out.println("received connect reply: " + (result == 0 ? "failed" : "ok"));
                }
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    protected void receiveConnect(DHTTransportContact rendezvous, Map request2, Map response) {
        DHTTransportContact target;
        if (TRACE) {
            System.out.println("received connect request");
        }
        boolean ok = false;
        DHTTransportContact rt = this.rendezvous_target;
        if (rt != null && rt.getAddress().equals(rendezvous.getAddress()) && (target = this.decodeContact((byte[])request2.get("origin"))) != null) {
            final int[] pings = new int[]{1};
            this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(UTTimerEvent event) {
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        if (pings[0] > 3) {
                            event.cancel();
                            return;
                        }
                        pings[0] = pings[0] + 1;
                    }
                    finally {
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                    target.sendPing(new DHTTransportReplyHandlerAdapter(this){
                        private final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void pingReply(DHTTransportContact ok_contact) {
                            if (DHTNATPuncherImpl.access$500()) {
                                System.out.println("tunnel ping ok");
                            }
                        }

                        public void failed(DHTTransportContact failed_contact, Throwable e) {
                        }
                    });
                }
            });
            target.sendPing(new DHTTransportReplyHandlerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void pingReply(DHTTransportContact ok_contact) {
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        pings[0] = 100;
                        if (TRACE) {
                            System.out.println("tunnel ping ok");
                        }
                    }
                    finally {
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                }

                public void failed(DHTTransportContact failed_contact, Throwable e) {
                }
            });
            ok = true;
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    public boolean punch(DHTTransportContact target) {
        try {
            DHTTransportContact rendezvous = this.getRendezvous(target);
            if (rendezvous == null) {
                return false;
            }
            if (this.sendPunch(rendezvous, target) == 0) {
                this.log("    punch to " + target.getString() + " succeeded");
                return true;
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        this.log("    punch to " + target.getString() + " failed");
        return false;
    }

    public void setRendezvous(DHTTransportContact target, DHTTransportContact rendezvous) {
        this.explicit_rendezvous_map.put(target.getAddress(), rendezvous);
        if (target.getAddress().equals(this.dht.getTransport().getLocalContact().getAddress())) {
            this.publish(true);
        }
    }

    protected DHTTransportContact getRendezvous(DHTTransportContact target) {
        DHTTransportContact explicit = (DHTTransportContact)this.explicit_rendezvous_map.get(target.getAddress());
        if (explicit != null) {
            return explicit;
        }
        byte[] key = this.getPublishKey(target);
        final DHTTransportValue[] result_value = new DHTTransportValue[]{null};
        final Semaphore sem = this.plugin_interface.getUtilities().getSemaphore();
        this.dht.get(key, "DHTNatPuncher: lookup for '" + target.getString() + "'", (byte)0, 1, 30000L, false, new DHTOperationAdapter(){

            public void read(DHTTransportContact contact, DHTTransportValue value) {
                result_value[0] = value;
                sem.release();
            }

            public void complete(boolean timeout) {
                sem.release();
            }
        });
        sem.reserve();
        DHTTransportContact result = null;
        if (result_value[0] != null) {
            byte[] bytes = result_value[0].getValue();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                DataInputStream dis = new DataInputStream(bais);
                byte version = dis.readByte();
                if (version != 0) {
                    throw new Exception("Unsupported rendezvous version '" + version + "'");
                }
                result = this.dht.getTransport().importContact(dis);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
        this.log("Lookup of rendezvous for " + target.getString() + " -> " + (result == null ? "None" : result.getString()));
        return result;
    }

    protected byte[] getPublishKey(DHTTransportContact contact) {
        byte[] id = contact.getID();
        byte[] suffix = ":DHTNATPuncher".getBytes();
        byte[] res = new byte[id.length + suffix.length];
        System.arraycopy(id, 0, res, 0, id.length);
        System.arraycopy(suffix, 0, res, id.length, suffix.length);
        return res;
    }

    protected byte[] encodePublishValue(DHTTransportContact contact) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(0);
            contact.exportContact(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            this.log(e);
            return new byte[0];
        }
    }

    protected byte[] encodeContact(DHTTransportContact contact) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            contact.exportContact(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected DHTTransportContact decodeContact(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            return this.dht.getTransport().importContact(dis);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected void log(String str) {
        this.logger.log("NATPuncher: " + str);
    }

    protected void log(Throwable e) {
        this.logger.log("NATPuncher: error occurred");
        this.logger.log(e);
    }

    static {
        if (TESTING) {
            System.out.println("**** DHTNATPuncher test on ****");
        }
        if (TRACE) {
            System.out.println("**** DHTNATPuncher trace on ****");
        }
        transfer_handler_key = new SHA1Simple().calculateHash("Aelitis:NATPuncher:TransferHandlerKey".getBytes());
    }
}

