/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.vivaldi.maths.impl;

import com.aelitis.azureus.core.dht.vivaldi.maths.Coordinates;
import com.aelitis.azureus.core.dht.vivaldi.maths.VivaldiPosition;
import com.aelitis.azureus.core.dht.vivaldi.maths.impl.HeightCoordinatesImpl;
import org.gudy.azureus2.core3.util.Debug;

public class VivaldiPositionImpl
implements VivaldiPosition {
    private static final float cc = 0.25f;
    private static final float ce = 0.5f;
    private static final float initial_error = 10.0f;
    private HeightCoordinatesImpl coordinates;
    private float error;
    private int nbUpdates;

    public VivaldiPositionImpl(HeightCoordinatesImpl coordinates) {
        this.coordinates = coordinates;
        this.error = 10.0f;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public float getErrorEstimate() {
        return this.error;
    }

    public void setErrorEstimate(float error) {
        this.error = error;
    }

    public void update(float rtt, Coordinates cj, float ej) {
        if (this.valid(rtt) && this.valid(ej) && cj.isValid()) {
            if (rtt < 0.0f) {
                return;
            }
            if (this.error + ej == 0.0f) {
                return;
            }
            float w = this.error / (ej + this.error);
            float re = rtt - this.coordinates.distance(cj);
            float es = Math.abs(re) / rtt;
            float new_error = es * 0.5f * w + this.error * (1.0f - 0.5f * w);
            float delta = 0.25f * w;
            float scale = delta * re;
            HeightCoordinatesImpl random_error = new HeightCoordinatesImpl((float)Math.random() / 10.0f, (float)Math.random() / 10.0f, 0.0f);
            HeightCoordinatesImpl new_coordinates = (HeightCoordinatesImpl)this.coordinates.add(this.coordinates.sub(cj.add(random_error)).unity().scale(scale));
            if (this.valid(new_error) && new_coordinates.isValid()) {
                this.coordinates = new_coordinates;
                this.error = new_error > 0.1f ? new_error : 0.1f;
            } else {
                Debug.out("VivaldiPosition: resetting as invalid: " + this.coordinates + "/" + this.error + " + " + rtt + "," + cj + "," + ej + "->" + new_coordinates + "/" + new_error);
                this.coordinates = new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f);
                this.error = 10.0f;
            }
            if (!cj.atOrigin()) {
                ++this.nbUpdates;
            }
            if (this.nbUpdates > 5) {
                this.nbUpdates = 0;
                this.update(10.0f, new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f), 50.0f);
            }
        }
    }

    private boolean valid(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    public void update(float rtt, float[] data) {
        this.update(rtt, new HeightCoordinatesImpl(data[0], data[1], data[2]), data[3]);
    }

    public float estimateRTT(Coordinates coordinates) {
        return this.coordinates.distance(coordinates);
    }

    public float[] toFloatArray() {
        return new float[]{this.coordinates.getX(), this.coordinates.getY(), this.coordinates.getH(), this.error};
    }

    public void fromFloatArray(float[] data) {
        this.coordinates = new HeightCoordinatesImpl(data[0], data[1], data[2]);
        this.error = data[3];
    }

    public String toString() {
        return this.coordinates + " : " + this.error;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VivaldiPositionImpl) {
            VivaldiPositionImpl other = (VivaldiPositionImpl)arg0;
            if (other.error != this.error) {
                return false;
            }
            return other.coordinates.equals(this.coordinates);
        }
        return false;
    }
}

