/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import java.io.File;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class Test {
    public static void main(String[] args) {
        System.setProperty("azureus.log.stdout", "1");
        Logger.addListener(new ILogEventListener(){

            public void log(LogEvent event) {
                System.out.println(event.text);
            }
        });
        try {
            CacheFileManagerImpl manager = (CacheFileManagerImpl)CacheFileManagerFactory.getSingleton();
            manager.initialise(true, true, true, 0xA00000L, 1024L);
            new Test().writeTest(manager);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void writeTest(CacheFileManagerImpl manager) {
        try {
            final File f = new File("C:\\temp\\cachetest.dat");
            f.delete();
            CacheFile cf = manager.createFile(new CacheFileOwner(){

                public String getCacheFileOwnerName() {
                    return "file " + f.toString();
                }

                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }

                public File getCacheFileControlFile(String name) {
                    return null;
                }
            }, f, 1);
            cf.setAccessMode(2);
            long start = System.currentTimeMillis();
            int loop = 10000;
            int block = 1024;
            for (int i = 0; i < loop; ++i) {
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)2, block);
                cf.writeAndHandoverBuffer(buffer, i * block);
            }
            cf.close();
            long now = System.currentTimeMillis();
            long total = loop * block;
            long elapsed = now - start;
            System.out.println("time = " + elapsed + ", speed = " + total / elapsed);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void manualTest(CacheFileManager manager) {
        try {
            final File f = new File("C:\\temp\\cachetest.dat");
            f.delete();
            CacheFile cf = manager.createFile(new CacheFileOwner(){

                public String getCacheFileOwnerName() {
                    return "file " + f.toString();
                }

                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }

                public File getCacheFileControlFile(String name) {
                    return null;
                }
            }, f, 1);
            DirectByteBuffer write_buffer1 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer write_buffer2 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer write_buffer3 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cf.writeAndHandoverBuffer(write_buffer2, 512L);
            cf.flushCache();
            cf.writeAndHandoverBuffer(write_buffer3, 1024L);
            cf.writeAndHandoverBuffer(write_buffer1, 0L);
            cf.flushCache();
            write_buffer1 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cf.writeAndHandoverBuffer(write_buffer1, 0L);
            cf.flushCache();
            cf.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void randomTest(CacheFileManager manager) {
        try {
            CacheFile[] files = new CacheFile[3];
            byte[][] file_data = new byte[3][];
            for (int i = 0; i < files.length; ++i) {
                final int f_i = i;
                file_data[i] = new byte[Test.randomInt(200000)];
                files[i] = manager.createFile(new CacheFileOwner(){

                    public String getCacheFileOwnerName() {
                        return "file" + f_i;
                    }

                    public TOTorrentFile getCacheFileTorrentFile() {
                        return null;
                    }

                    public File getCacheFileControlFile(String name) {
                        return null;
                    }
                }, new File("C:\\temp\\cachetest" + i + ".dat"), 1);
                files[i].setAccessMode(2);
                DirectByteBuffer bb = DirectByteBufferPool.getBuffer((byte)2, file_data[i].length);
                bb.put((byte)3, file_data[i]);
                bb.position((byte)3, 0);
                files[i].write(bb, 0L);
            }
            int quanitize_to = 100;
            int quanitize_to_max_consec_write = 1;
            int quanitize_to_max_consec_read = 3;
            for (int x = 0; x < 10000000; ++x) {
                DirectByteBuffer buffer;
                int file_index = Test.randomInt(files.length);
                CacheFile cf = files[file_index];
                byte[] bytes = file_data[file_index];
                int p1 = Test.randomInt(bytes.length);
                int p2 = Test.randomInt(bytes.length);
                if ((p1 = p1 / quanitize_to * quanitize_to) == (p2 = p2 / quanitize_to * quanitize_to)) continue;
                int start = Math.min(p1, p2);
                int len = Math.max(p1, p2) - start;
                int function = Test.randomInt(100);
                if (function < 30) {
                    if (len > quanitize_to * quanitize_to_max_consec_read) {
                        len = quanitize_to * quanitize_to_max_consec_read;
                    }
                    buffer = DirectByteBufferPool.getBuffer((byte)2, len);
                    System.out.println("read:" + start + "/" + len);
                    cf.read(buffer, start, (short)1);
                    buffer.position((byte)3, 0);
                    byte[] data_read = new byte[len];
                    buffer.get((byte)3, data_read);
                    for (int i = 0; i < data_read.length; ++i) {
                        if (data_read[i] == bytes[i + start]) continue;
                        throw new Exception("data read mismatch");
                    }
                    buffer.returnToPool();
                    continue;
                }
                if (function < 80) {
                    if (len > quanitize_to * quanitize_to_max_consec_write) {
                        len = quanitize_to * quanitize_to_max_consec_write;
                    }
                    System.out.println("write:" + start + "/" + len);
                    buffer = DirectByteBufferPool.getBuffer((byte)2, len);
                    for (int i = 0; i < len; ++i) {
                        bytes[start + i] = (byte)Test.randomInt(256);
                        buffer.put((byte)3, bytes[start + i]);
                    }
                    buffer.position((byte)3, 0);
                    cf.writeAndHandoverBuffer(buffer, start);
                    continue;
                }
                if (function < 90) {
                    cf.flushCache();
                    continue;
                }
                if (function >= 91) continue;
                cf.clearCache();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static int randomInt(int num) {
        return (int)(Math.random() * (double)num);
    }
}

