/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.monitoring.thread;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;

public class AEThreadMonitor {
    private static void monitor() {
        AEDiagnosticsLogger log = AEDiagnostics.getLogger("thread");
        int num_processors = Runtime.getRuntime().availableProcessors();
        if (num_processors < 1) {
            num_processors = 1;
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        log.log("Monitoring starts (processors =" + num_processors + ")");
        if (!bean.isThreadCpuTimeEnabled()) {
            log.log("current thread cpu time not supported");
            return;
        }
        if (!bean.isThreadCpuTimeEnabled()) {
            bean.setThreadCpuTimeEnabled(true);
        }
        HashMap last_times = new HashMap();
        long time_available = 10000L;
        while (true) {
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(time_available);
            }
            catch (Throwable e) {
                log.log(e);
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            long[] ids = bean.getAllThreadIds();
            long[] diffs = new long[ids.length];
            long total_diffs = 0L;
            long biggest_diff = 0L;
            int biggest_index = 0;
            HashMap<Long, Long> new_times = new HashMap<Long, Long>();
            for (int i = 0; i < ids.length; ++i) {
                long id = ids[i];
                long time = bean.getThreadCpuTime(id) / 1000000L;
                Long old_time = (Long)last_times.get(id);
                if (old_time != null) {
                    long diff = time - old_time;
                    if (diff > biggest_diff) {
                        biggest_diff = diff;
                        biggest_index = i;
                    }
                    diffs[i] = diff;
                    total_diffs += diff;
                }
                new_times.put(id, time);
            }
            ThreadInfo info = bean.getThreadInfo(ids[biggest_index]);
            String thread_name = info == null ? "<dead>" : info.getThreadName();
            int percent = (int)(100L * biggest_diff / time_available);
            Runtime rt = Runtime.getRuntime();
            log.log("Thread state: elapsed = " + elapsed + ", cpu = " + total_diffs + ", max = " + thread_name + " (" + biggest_diff + "/" + percent + "%), mem=" + rt.maxMemory() / 1024L + ":" + rt.totalMemory() / 1024L + ":" + rt.freeMemory() / 1024L);
            if (biggest_diff > time_available / 4L) {
                info = bean.getThreadInfo(ids[biggest_index], 255);
                if (info == null) {
                    log.log("    no info for max thread");
                } else {
                    StackTraceElement[] elts = info.getStackTrace();
                    String str = "";
                    for (int i = 0; i < elts.length; ++i) {
                        str = str + (i == 0 ? "" : ", ") + elts[i].toString();
                    }
                    log.log("    " + str);
                }
            }
            last_times = new_times;
        }
    }

    static {
        AEThread thread = new AEThread("AEThreadMonitor"){

            public void runSupport() {
                try {
                    AEThreadMonitor.monitor();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(10);
        thread.setDaemon(true);
        thread.start();
    }
}

