/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class IncomingSocketChannelManager
implements VirtualChannelSelector.VirtualSelectorListener {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    public static final int READ_TIMEOUT = 10000;
    public static final int CONNECT_TIMEOUT = 60000;
    private final ArrayList connections = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("IncomingConnectionManager:conns");
    private volatile Map match_buffers_cow = new HashMap();
    private final AEMonitor match_buffers_mon = new AEMonitor("IncomingConnectionManager:match");
    private int max_match_buffer_size = 0;
    private int max_min_match_buffer_size = 0;
    private int listen_port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    private int so_rcvbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
    private String bind_address = COConfigurationManager.getStringParameter("Bind IP");
    private long last_timeout_check_time = SystemTime.getCurrentTime();
    private VirtualServerChannelSelector server_selector = null;
    protected AEMonitor this_mon = new AEMonitor("IncomingSocketChannelManager");

    public IncomingSocketChannelManager() {
        COConfigurationManager.addParameterListener("TCP.Listen.Port", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                if (port != IncomingSocketChannelManager.this.listen_port) {
                    IncomingSocketChannelManager.this.listen_port = port;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        COConfigurationManager.addParameterListener("network.tcp.socket.SO_RCVBUF", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                if (size != IncomingSocketChannelManager.this.so_rcvbuf_size) {
                    IncomingSocketChannelManager.this.so_rcvbuf_size = size;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                String address = COConfigurationManager.getStringParameter("Bind IP");
                if (!address.equals(IncomingSocketChannelManager.this.bind_address)) {
                    IncomingSocketChannelManager.this.bind_address = address;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        this.start();
        AEThread checker = new AEThread("ServerSocketChecker"){

            public void runSupport() {
                try {
                    Thread.sleep(60000L);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                int fail_count = 0;
                while (true) {
                    block13: {
                        if (IncomingSocketChannelManager.this.server_selector != null && IncomingSocketChannelManager.this.server_selector.isRunning()) {
                            long accept_idle = SystemTime.getCurrentTime() - IncomingSocketChannelManager.this.server_selector.getTimeOfLastAccept();
                            if (accept_idle > 600000L) {
                                InetAddress inet_address = IncomingSocketChannelManager.this.server_selector.getBoundToAddress();
                                try {
                                    if (inet_address == null) {
                                        inet_address = InetAddress.getByName("127.0.0.1");
                                    }
                                    Socket sock = new Socket(inet_address, IncomingSocketChannelManager.this.listen_port, inet_address, 0);
                                    sock.close();
                                    fail_count = 0;
                                }
                                catch (Throwable t) {
                                    try {
                                        Socket sock = new Socket(InetAddress.getByName("127.0.0.1"), IncomingSocketChannelManager.this.listen_port);
                                        sock.close();
                                        fail_count = 0;
                                        break block13;
                                    }
                                    catch (Throwable x) {
                                        Debug.out(new Date() + ": listen port on [" + inet_address + ": " + IncomingSocketChannelManager.this.listen_port + "] seems CLOSED [" + ++fail_count + "x]");
                                        if (fail_count > 4) {
                                            String error = t.getMessage() == null ? "<null>" : t.getMessage();
                                            String msg = "Listen server socket on [" + inet_address + ": " + IncomingSocketChannelManager.this.listen_port + "] does not appear to be accepting inbound connections.\n[" + error + "]\nAuto-repairing listen service....\n";
                                            Logger.log(new LogAlert(false, 1, msg));
                                            IncomingSocketChannelManager.this.restart();
                                            fail_count = 0;
                                        }
                                        break block13;
                                    }
                                }
                            }
                            fail_count = 0;
                        }
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        checker.setDaemon(true);
        checker.start();
    }

    public int getTCPListeningPortNumber() {
        return this.listen_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchBytes(NetworkManager.ByteMatcher matcher, MatchListener listener) {
        try {
            this.match_buffers_mon.enter();
            if (matcher.size() > this.max_match_buffer_size) {
                this.max_match_buffer_size = matcher.size();
            }
            if (matcher.minSize() > this.max_min_match_buffer_size) {
                this.max_min_match_buffer_size = matcher.minSize();
            }
            HashMap<NetworkManager.ByteMatcher, MatchListener> new_match_buffers = new HashMap<NetworkManager.ByteMatcher, MatchListener>(this.match_buffers_cow);
            new_match_buffers.put(matcher, listener);
            this.match_buffers_cow = new_match_buffers;
            byte[] secret = matcher.getSharedSecret();
            if (secret != null) {
                TCPProtocolDecoder.addSecret(secret);
            }
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchBytes(NetworkManager.ByteMatcher to_remove) {
        try {
            this.match_buffers_mon.enter();
            HashMap new_match_buffers = new HashMap(this.match_buffers_cow);
            new_match_buffers.remove(to_remove);
            if (to_remove.size() == this.max_match_buffer_size) {
                this.max_match_buffer_size = 0;
                Iterator i = new_match_buffers.keySet().iterator();
                while (i.hasNext()) {
                    NetworkManager.ByteMatcher bm = (NetworkManager.ByteMatcher)i.next();
                    if (bm.size() <= this.max_match_buffer_size) continue;
                    this.max_match_buffer_size = bm.size();
                }
            }
            this.match_buffers_cow = new_match_buffers;
            byte[] secret = to_remove.getSharedSecret();
            if (secret != null) {
                TCPProtocolDecoder.removeSecret(secret);
            }
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        block6: {
            try {
                InetSocketAddress address;
                this.this_mon.enter();
                if (this.listen_port < 0 || this.listen_port > 65535 || this.listen_port == 6880) {
                    String msg = "Invalid incoming listen port configured, " + this.listen_port + ". Port reset to default. Please check your config!";
                    Debug.out(msg);
                    Logger.log(new LogAlert(false, 3, msg));
                    this.listen_port = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter("TCP.Listen.Port", this.listen_port);
                }
                if (this.server_selector != null) break block6;
                try {
                    address = this.bind_address.length() > 0 ? new InetSocketAddress(InetAddress.getByName(this.bind_address), this.listen_port) : new InetSocketAddress(this.listen_port);
                }
                catch (UnknownHostException e) {
                    Debug.out(e);
                    address = new InetSocketAddress(this.listen_port);
                }
                this.server_selector = new VirtualServerChannelSelector(address, this.so_rcvbuf_size, new VirtualServerChannelSelector.SelectListener(){

                    public void newConnectionAccepted(SocketChannel channel) {
                        TransportCryptoManager.getSingleton().manageCrypto(channel, null, true, new TransportCryptoManager.HandshakeListener(this, channel){
                            private final /* synthetic */ SocketChannel val$channel;
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$channel = val$channel;
                            }

                            public void handshakeSuccess(TCPTransportHelperFilter filter) {
                                5.access$500(this.this$1).process(filter);
                            }

                            public void handshakeFailure(Throwable failure_msg) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(IncomingSocketChannelManager.access$600(), "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(failure_msg)));
                                }
                                NetworkManager.getSingleton().closeSocketChannel(this.val$channel);
                            }

                            public int getMaximumPlainHeaderLength() {
                                return IncomingSocketChannelManager.access$700(5.access$500(this.this$1));
                            }

                            public int matchPlainHeader(ByteBuffer buffer) {
                                MatchListener match = 5.access$500(this.this$1).checkForMatch(buffer, true);
                                if (match == null) {
                                    return 1;
                                }
                                if (match.autoCryptoFallback()) {
                                    return 3;
                                }
                                return 2;
                            }
                        });
                    }

                    static /* synthetic */ IncomingSocketChannelManager access$500(5 x0) {
                        return x0.IncomingSocketChannelManager.this;
                    }
                });
                this.server_selector.start();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(TCPTransportHelperFilter filter) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_timeout_check_time || now - this.last_timeout_check_time > 5000L) {
            this.doTimeoutChecks();
            this.last_timeout_check_time = now;
        }
        if (this.match_buffers_cow.isEmpty()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming TCP connection from [" + filter.getSocketChannel().socket().getInetAddress().getHostAddress() + ":" + filter.getSocketChannel().socket().getPort() + "] dropped because zero routing handlers registered"));
            }
            NetworkManager.getSingleton().closeSocketChannel(filter.getSocketChannel());
            return;
        }
        try {
            String ip_tos;
            int so_sndbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF");
            if (so_sndbuf_size > 0) {
                filter.getSocketChannel().socket().setSendBufferSize(so_sndbuf_size);
            }
            if ((ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPTOS")).length() > 0) {
                filter.getSocketChannel().socket().setTrafficClass(Integer.decode(ip_tos));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        IncomingConnection ic = new IncomingConnection(filter, this.max_match_buffer_size);
        VirtualChannelSelector selector = NetworkManager.getSingleton().getReadSelector();
        try {
            this.connections_mon.enter();
            this.connections.add(ic);
            selector.register(ic.filter.getSocketChannel(), this, ic);
        }
        finally {
            this.connections_mon.exit();
        }
        this.selectSuccess(selector, ic.filter.getSocketChannel(), ic);
    }

    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
        IncomingConnection ic = (IncomingConnection)attachment;
        try {
            long bytes_read = ic.filter.read(new ByteBuffer[]{ic.buffer}, 0, 1);
            if (bytes_read < 0L) {
                throw new IOException("end of stream on socket read");
            }
            if (bytes_read == 0L) {
                return false;
            }
            ic.last_read_time = SystemTime.getCurrentTime();
            MatchListener listener = this.checkForMatch(ic.buffer, false);
            if (listener == null) {
                if (ic.buffer.position() >= this.max_match_buffer_size) {
                    ic.buffer.flip();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Incoming TCP stream from [" + sc.socket().getInetAddress().getHostAddress() + ":" + sc.socket().getPort() + "] does not match " + "any known byte pattern: " + ByteFormatter.nicePrint(ic.buffer.array())));
                    }
                    this.removeConnection(ic, true);
                }
            } else {
                ic.buffer.flip();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming TCP stream from [" + sc.socket().getInetAddress().getHostAddress() + ":" + sc.socket().getPort() + "] recognized as " + "known byte pattern: " + ByteFormatter.nicePrint(ic.buffer.array())));
                }
                this.removeConnection(ic, false);
                listener.connectionMatched(ic.filter, ic.buffer);
            }
        }
        catch (Throwable t) {
            try {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "Incoming TCP connection [" + sc.socket().getInetAddress().getHostAddress() + ":" + sc.socket().getPort() + "] socket read exception: " + t.getMessage()));
                }
            }
            catch (Throwable x) {
                Debug.out("Caught exception on incoming exception log:");
                x.printStackTrace();
                System.out.println("CAUSED BY:");
                t.printStackTrace();
            }
            this.removeConnection(ic, true);
        }
        return true;
    }

    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
        IncomingConnection ic = (IncomingConnection)attachment;
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, 3, "Incoming TCP connection [" + sc + "] socket select op failure: " + msg.getMessage()));
        }
        this.removeConnection(ic, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            this.this_mon.enter();
            if (this.server_selector != null) {
                this.server_selector.stop();
                this.server_selector = null;
            }
        }
        finally {
            this.this_mon.exit();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(IncomingConnection connection, boolean close_as_well) {
        try {
            this.connections_mon.enter();
            NetworkManager.getSingleton().getReadSelector().cancel(connection.filter.getSocketChannel());
            this.connections.remove(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (close_as_well) {
            NetworkManager.getSingleton().closeSocketChannel(connection.filter.getSocketChannel());
        }
    }

    protected MatchListener checkForMatch(ByteBuffer to_check, boolean min_match) {
        int orig_position = to_check.position();
        int orig_limit = to_check.limit();
        to_check.position(0);
        MatchListener listener = null;
        Iterator i = this.match_buffers_cow.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry2 = i.next();
            NetworkManager.ByteMatcher bm = (NetworkManager.ByteMatcher)entry2.getKey();
            if (min_match) {
                if (orig_position < bm.minSize() || !bm.minMatches(to_check)) continue;
                listener = (MatchListener)entry2.getValue();
                break;
            }
            if (orig_position < bm.size() || !bm.matches(to_check)) continue;
            listener = (MatchListener)entry2.getValue();
            break;
        }
        to_check.position(orig_position);
        to_check.limit(orig_limit);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTimeoutChecks() {
        try {
            IncomingConnection ic;
            int i;
            this.connections_mon.enter();
            ArrayList<IncomingConnection> to_close = null;
            long now = SystemTime.getCurrentTime();
            for (i = 0; i < this.connections.size(); ++i) {
                ic = (IncomingConnection)this.connections.get(i);
                if (ic.last_read_time > 0L) {
                    if (now < ic.last_read_time) {
                        ic.last_read_time = now;
                        continue;
                    }
                    if (now - ic.last_read_time <= 10000L) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming TCP connection [" + ic.filter.getSocketChannel().socket().getInetAddress().getHostAddress() + ":" + ic.filter.getSocketChannel().socket().getPort() + "] forcibly timed out due to socket read inactivity [" + ic.buffer.position() + " bytes read: " + new String(ic.buffer.array()) + "]"));
                    }
                    if (to_close == null) {
                        to_close = new ArrayList<IncomingConnection>();
                    }
                    to_close.add(ic);
                    continue;
                }
                if (now < ic.initial_connect_time) {
                    ic.initial_connect_time = now;
                    continue;
                }
                if (now - ic.initial_connect_time <= 60000L) continue;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming TCP connection [" + ic.filter.getSocketChannel() + "] forcibly timed out after " + "60sec due to socket inactivity"));
                }
                if (to_close == null) {
                    to_close = new ArrayList();
                }
                to_close.add(ic);
            }
            if (to_close != null) {
                for (i = 0; i < to_close.size(); ++i) {
                    ic = (IncomingConnection)to_close.get(i);
                    this.removeConnection(ic, true);
                }
            }
        }
        finally {
            this.connections_mon.exit();
        }
    }

    static /* synthetic */ LogIDs access$600() {
        return LOGID;
    }

    static /* synthetic */ int access$700(IncomingSocketChannelManager x0) {
        return x0.max_min_match_buffer_size;
    }

    public static interface MatchListener {
        public boolean autoCryptoFallback();

        public void connectionMatched(TCPTransportHelperFilter var1, ByteBuffer var2);
    }

    protected static class IncomingConnection {
        protected final TCPTransportHelperFilter filter;
        protected final ByteBuffer buffer;
        protected long initial_connect_time;
        protected long last_read_time = -1L;

        protected IncomingConnection(TCPTransportHelperFilter filter, int buff_size) {
            this.filter = filter;
            this.buffer = ByteBuffer.allocate(buff_size);
            this.initial_connect_time = SystemTime.getCurrentTime();
        }
    }
}

